/*
 * $Id: nt_applet.h,v 1.17 2000/11/28 22:39:51 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifndef __NT_APPLET_H_
#define __NT_APPLET_H_

#include <applet-widget.h>
#include "nt_property.h"

BEGIN_GNOME_DECLS

typedef enum _NTAppletState {
	NTA_STATE_UNDEFINED,
	NTA_STATE_NOT_RUN,
	NTA_STATE_NO_FILES,
	NTA_STATE_LOAD,
	NTA_STATE_ERROR
} NTAppletState;

typedef enum _NTAppletMode {
	NTA_MODE_CONTINUE = 0,
	NTA_MODE_SWITCH   = 1,
	NTA_MODE_BLINK    = 2,
	NTA_MODE_STOP     = 3
} NTAppletMode;

typedef enum _NTAppletDirection {
	NTA_DIR_FORWARD  = 0,
	NTA_DIR_BACKWARD = 1,
	NTA_DIR_PINGPONG = 2
} NTAppletDirection;

#define GTK_TYPE_NT_APPLET        (nt_applet_get_type ())
#define NT_APPLET(obj)            (GTK_CHECK_CAST (obj, GTK_TYPE_NT_APPLET, NTApplet))
#define NT_APPLET_CLASS(klass)    (GTK_CHECK_CLASS_CAST (klass, GTK_TYPE_NT_APPLET, NTAppletClass))
#define IS_NT_APPLET(obj)         (GTK_CHECK_TYPE (obj, GTK_TYPE_NT_APPLET))
#define NT_APPLET_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_NT_APPLET, NTAppletClass))
#define IS_NT_APPLET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_NT_APPLET))

typedef struct _NTApplet NTApplet;
typedef struct _NTAppletClass NTAppletClass;

struct _NTApplet {
	AppletWidget applet;

	GtkWidget *animator;

	gchar *animation_fname;
	gchar *tile_up_fname;
	gchar *tile_down_fname;

	gint direction;
	gint mode;
	gint download_cmd;

	guint    timer_id;
	guint    cur_frame;
	gint     next_frame;
	gboolean blink_state;

	gchar         buffer[PATH_MAX];
	NTAppletState prev_state;
	gint          prev_speed;
};

struct _NTAppletClass {
	AppletWidgetClass applet_class;
};

GtkType    nt_applet_get_type (void);
GtkWidget  *nt_applet_new (const gchar *goad_id);
void       nt_applet_construct (NTApplet *na, const gchar *goad_id);

void nt_applet_tooltip_set   (NTApplet *na, gchar *tip);
void nt_applet_state_set     (NTApplet *na, NTAppletState state, gint speed);
void nt_applet_config_reload (NTApplet *na, NTProps *ntp);
#define nt_applet_get_config_name(na) ((APPLET_WIDGET (na))->privcfgpath)

END_GNOME_DECLS

#endif
