/*
 * $Id: main.c,v 1.12 2001/01/25 22:52:05 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <config.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <config.h>
#include <gnome.h>
#include <gdk/gdkx.h>
#include <applet-widget.h>

#include "nt_property.h"
#include "nt_applet.h"
#include "nt.h"

static GtkObject *nt = NULL;

static GtkWidget *start_new_applet (const gchar *goad_id, const char **params, int nparams);

int
main (int argc, char **argv)
{
	const gchar *goad_id;
	struct sigaction sa;

	sa.sa_handler = SIG_IGN;
	sa.sa_flags   = SA_NOCLDSTOP;
	sigemptyset (&sa.sa_mask);
	sigaction   (SIGCHLD, &sa, NULL);

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	applet_widget_init (PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
	gdk_rgb_init ();

	goad_id = goad_server_activation_id ();

	if (!goad_id)
	{
		g_error ("Can't get goad_id");
		return 1;
	}

	nt = nt_new ();

	if (!nt)
	{
		g_error ("Can't create nt object");
		return 1;
	}

	applet_factory_new ("nt_applet_factory", NULL, start_new_applet);

	if (strcmp (goad_id, "nt_applet") == 0)
		start_new_applet (goad_id, NULL, 0);

	applet_widget_gtk_main ();

	gtk_object_unref (nt);

	return 0;
}

static GtkWidget *
start_new_applet (const gchar *goad_id, const char **params, int nparams)
{
	GtkWidget *nt_applet;
	GtkObject *nt_props;

	g_return_val_if_fail ((strcmp (goad_id, "nt_applet") == 0), NULL);

	nt_applet = nt_applet_new (goad_id);
	nt_props  = nt_props_new ();

	if (!nt_applet || !nt_props)
	{
		if (nt_applet) gtk_object_unref (GTK_OBJECT (nt_applet));
		if (nt_props)  gtk_object_unref (GTK_OBJECT (nt_props));

		g_warning ("Can't create new applet instance!\n");
		return NULL;
	}

	gtk_signal_connect_object (nt, "tip_changed",   GTK_SIGNAL_FUNC (nt_applet_tooltip_set), GTK_OBJECT (nt_applet));
	gtk_signal_connect_object (nt, "state_changed", GTK_SIGNAL_FUNC (nt_applet_state_set),   GTK_OBJECT (nt_applet));

	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "url_dropped",  GTK_SIGNAL_FUNC (nt_download_uri),       nt);
	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "clicked",      GTK_SIGNAL_FUNC (nt_open_window),        nt);
	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "properties",   GTK_SIGNAL_FUNC (nt_props_open),         nt_props);
	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "save_session", GTK_SIGNAL_FUNC (nt_props_save_session), nt_props);

	gtk_signal_connect_object (nt_props, "config_changed", GTK_SIGNAL_FUNC (nt_applet_config_reload), GTK_OBJECT (nt_applet));

	/* cleanup signals and objects */
	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "destroy", GTK_SIGNAL_FUNC (gtk_object_unref),              nt_props);
	gtk_signal_connect_object (GTK_OBJECT (nt_applet), "destroy", GTK_SIGNAL_FUNC (gtk_signal_disconnect_by_data), nt);

	nt_props_load (NT_PROPS (nt_props), nt_applet_get_config_name (nt_applet), NULL);

	gtk_widget_show (nt_applet);

	return nt_applet;
}
