/***************************************************************************
                          datendatei.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATENDATEI_H
#define DATENDATEI_H

#include <qstring.h>
#include <qstrlist.h>
#include <qcolor.h>
#include <qfile.h>
#include <qtextstream.h>

#include "inkompatibel.h"
#include "knoten.h"

class Code;


/** Parst die level.descr Datei und alle Dateien, die davon included
    werden. Bietet danach Mglichkeiten, darauf zuzugreifen.
    
    Noch ein Hinweis: Auf dem geparsten Baum befindet sich ein
    Eichhrnchen (= Squirrel; ist schneller zu tippen), dass sich um
    das Auslesen der Daten kmmert. Es liest natrlich die Daten von
    dort, wo es sich befindet. (Und es gibt Methoden, die ihm sagen,
    wo es hingehen soll.)
    
    (Oje, ist die Wurzel des Baums jetzt oben oder unten?)

    Ausfhrliche Beschreibung des Parse-Vorgangs siehe leveldaten.h.
    
    Nicht zu verwechseln mit ConfigDatei, was die alte Version von
    level.descr geparst hat und jetzt nur noch fr die .cuyo-Datei
    verwendet wird.
    @author Immi
  */


class DatenDateiPush;


class DatenDatei {
 friend class DatenDateiPush;
 
 public:
  DatenDatei();
  ~DatenDatei();

  /** Entfernt alles, was bisher geladen wurde. Aufrufen, wenn man alles
      neu laden mchte. */
  void leeren();  

  /** Ldt die angegebene Datei. (Kann mehrmals aufgerufen werden, um
      mehrere Dateien gleichzeitig zu laden.) */
  void laden(__String name);

  /** Setzt, ob nach Ein-Spieler-Version-Schlsseln
      gesucht werden soll */
  void setEinSpielerVersion(bool esv = false);


  /***** Squirrel-Methoden *****/
  
  /** Setzt das Squirrel an die Wurzel des Baums. */
  void initSquirrel();
  
  /** Liefert true, wenn das Squirrel sich an einer Stelle des Baums
      befindet, die existiert. */
  bool existiertSquirrelKnoten() const;
  
  /** Liefert die Position des Squirrels als String. */
  __String getSquirrelPosString() const;
  
  /** Liefert die Squirrel-Position zurck (und zwar
      mSquirrelCodeKnoten; siehe dort). */
  DefKnoten * getSquirrelPos() const;


protected:
  /** Das Eichhrnchen klettert weiter weg von der Wurzel. Wird von
      DatenDateiPush benutzt. */
  void kletterWeiter(__String na);
  
public:



  /***** Eintrag-Methoden *****/
  
  /** Liefert den Eintrag, wenn er existiert, sonst null.
      Schaut ggf. nach EinSpieler-Eintrag. */
  const DatenKnoten * getEintrag(__String schluessel,
				 int typ = type_EgalDatum) const;
  /** Dito fr Wrter, hat aber default. Default fr default ist null. */
  __String getWortEintrag(__String schluessel,
			  __String def = __String()) const;
  
  /** Gibt's den Eintrag? */
  bool hatEintrag(__String schluessel) const;
  /** Liefert den Eintrag als Zahl, wenn er existiert, sonst die
      default-Zahl. */
  int getZahlEintrag(__String schluessel, int def = 0) const;
  /** Liefert den Eintrag als Farbe, wenn er existiert, sonst die
      default-Farbe. */
  QColor getFarbEintrag(__String schluessel,
                        const QColor & def = __black) const;
  /** Liefert einen Eintrag als Knoten */
  ListenKnoten * getListenEintrag(__String schluessel) const;

  /** Sucht einen Code beim Squirrel oder nher an der Wurzel.
      Behlt den Besitz am Code.
      Throwt bei nicht-existenz. */
  Code * getCode(int ns, __String name);




 protected:
 
   /** Der oberste Knoten der (geparsten) Datei */
   DefKnoten * mDaten;
   /* true, falls einspieler-Modus */
   bool mEinSpielerVersion;
  
  /* Ort des Eichhrnchens als String. */
  __String mSquirrelPosString;
  /* Der Knoten, an dem sich das Squirrel befindet. Ist 0, wenn es sich
     an einem Knoten befindet, den es gar nicht gibt. */
  DefKnoten * mSquirrelKnoten;
  /* Eigentlich auch der Knoten des Squirrels. Wenn
     der allerdings nicht existiert, dann der letzte Knoten,
     der noch existiert hat. Dort wird nach Code gesucht. */
  DefKnoten * mSquirrelCodeKnoten;


  /** Liefert den angegebenen Eintrag beim Squirrel.
      Macht ggf. 1-Spieler-Modus-Schlsselumbenennungen.
      Prft, ob der Typ der gewnschte ist.
      Liefert 0, wenn's den Eintrag nicht gibt.
      Throwt bei sonstigem Fehler. */
  Knoten * getEintragKnoten(__String schluessel, int typ) const;

};




/***************************************************************************/



/** Ist dazu da, um bei einer Datendatei das Squirrel klettern zu lassen.
    Gebrauchsanweisung:
    {
      DatenDateiPush ddp(dat, "Unterabschnitt");
      if (!hatGeklappt)
        throw Fehler("Abschnitt existiert nicht");
      ...
    } // Hier automatisch Ende vom Push
    */
class DatenDateiPush {
 public:
  DatenDateiPush(DatenDatei & c, __String name,
                 bool verlange = true);
		 
  ~DatenDateiPush();
  
 protected:
  DatenDatei & mConf;
  __String mMerkName;
  DefKnoten * mMerkKnoten;
  DefKnoten * mMerkCodeKnoten;
};




#endif
