/***************************************************************************
                          prefsdaten.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFSDATEN_H
#define PREFSDATEN_H

#include <qstrlist.h>



/** Datenstruktur fr das, was in .cuyo steht:
    Das, was man im preferences-Dialog einstellen kann und
    welche Level gewonnen wurden. */

class PrefsDaten {

 public:
 
  /** Prefs-Objekt erzeugen und nach gPrefs speichern. */
  PrefsDaten();
  /** Zeigt den Preferences-Dialog und kmmert sich dabei um alles. */
  void preferencesDialog(QWidget * parent);
  /** Zeigt den start-at-Dialog und kmmert sich dabei um alles.
      Liefert true, wenn gestartet werden soll. Speichert den
      gewhlten Level in lnr.
      sp2: true bei zweispielermodus */
  bool startAtDialog(QWidget * parent, bool sp2, int & lnr) const;
  
  /** sp2: true bei zweispielermodus */
  void schreibGewonnenenLevel(bool sp2, int lnr);
  
  /** Liefert true, wenn die Taste k belegt ist, und speichert dann
      in sp und t ab, was die Taste tut. */
  bool getTaste(int k, int & sp, int & t) const;

  bool getUnfertigeLevel() const { return mUnfertigeLevel; }
  
  double getKIGeschwLin() const { return mKIGeschwLin; }

 private:
 
  /** Die Steuer-Tasten... */
  int mTasten[2][4];
  /** Welche Level wurden schon gewonnen: im 1-Spieler-Modus und im
      Mehr-Spieler-Modus */
  QStrList mGewonneneLevel[2];

  /** True, wenn auch unfertige Level gespielt werden sollen. */
  bool mUnfertigeLevel;
 
  /** Geschwindigkeit des KI-Players, so wie man's einstellen mchte */
  int mKIGeschwLog;
  /** Die Zahl, an der der KI-Player interessiert ist. */
  double mKIGeschwLin;




  __String getPrefsName();
  void liesPreferences();
  void schreibPreferences();
  
  void calcKILangsamLin();
};


extern PrefsDaten * gPrefs;

#endif
