/***************************************************************************
                          sorte.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include "cuyointl.h"
#include "leveldaten.h"

#include "fehler.h"
#include "pfaditerator.h"
#include "sorte.h"


/* Die verschiedenen Schemen...; diese Konstanten werden hauptschlich von
   malMitVerbindungen benutzt */
#define schema_keins -1 // Dann muss alles ber 8er-Ausnahmen geregelt sein
#define schema_normal 0
#define schema_viertel 1
#define schema_minimal 2
#define schema_einbild 3 // Insbesondere das Schema wenn nicht verbindbar
#define schema_sechseck 4
#define schema_mauer 5
#define schema_schraeg_minimal 6



/* Fr getEckVerbindung */
int ev_lo_ru[4] = {5319, 3790, 1942, 9026}; // liob, reob, liun, reun
int ev_lmr[4] = {1539, 3709, 2419,  629};   // links, mitte, rechts
/* Rechtseste Ziffer in diesen Arrays gibt linksestes Bit in
   getEckVerbindung()-Ergebnis an. */

/*#define verbindung_rechts 0x0001
  #define verbindung_links  0x0002
  #define verbindung_unten  0x0004                 5 3 7
  #define verbindung_oben   0x0008                 1 9 0
  #define verbindung_lu     0x0010                 4 2 6
  #define verbindung_lo     0x0020
  #define verbindung_ru     0x0040
  #define verbindung_ro     0x0080
  #define verbindung_solo   0x0100*/
			



/* Liefert true, wenn der Blop mit dem angegebenen Zustand zu der Animation
	 passt. Prft nur die Sorte und die Schemapos, _nicht_ ob die Animation
	 eigentlich fr Synchron bestimmt ist. */
bool AnimEinsprung::animPasst(const BlopZustand & zust) const {
  if (mVersionen.drin(zust.mVersion + 'A')) // provisorisch!!!
    if (mSchemaPos.ueberschneidet(zust.mBenutzteSchemaPos))
      return true;
  return false;
}

/** Prft (mit passtAnim) ob die Animation passt und startet sie
    mit der richtigen Wahrscheinlichkeit. Prft _auch_, ob die Animation
    fr Synchron bestimmt ist (und der zust zur Sync-Anim gehrt)
    Das starten der Animation
    besteht darin, die Einsprungstelle zurckzuliefern. */
int AnimEinsprung::starteVielleichtAnim(const BlopZustand & zust) const {
  /* Sonderfall-Animation? Dann nicht starten */
  if (mAnimZeit <= 0)
    return 0;
  
  if (rand() % mAnimZeit == 0) {
    
    /* Sync-Animation-zust? */
    if (zust.mVersion == -1) {
      /* Dann passen alle Sync-Animationen */
      if (mSync)
	return mEinsprung;
    } else {
      /* Keine Sync-Anim? Dann Sorte und Schemapos checken */
      if (!mSync && animPasst(zust))
	return mEinsprung;
    }
  }
  return 0;
}






Sorte::Sorte(){
  mAnimEinspruenge.setAutoDelete(true);
}
Sorte::~Sorte(){
  loeschBilder();
}

/** Ldt die Sorte mit dem angegebenen Namen. Schaut auch in der
    entsprechenden Gruppe von mLevelConf nach, setzt die Gruppe
    aber danach zurck. Fr verbart gibt's Konstanten zum bergeben.
    Throwt Fehler, wenn erfolglos. */
void Sorte::laden(__String name, int verbart, bool vmr /*= false*/) {

  /* Erst mal ein paar defaults setzen */
  mSchema = verbart == verbart_ja ? schema_normal : schema_einbild;
  mNachbarschaft = ld->mNachbarschaft;
          // Default = levelweite Nachbarschaftseinstellung
  mSpringerStriche = 0; // keine "Springer-Striche"
  mSchemaAusnahme1 = 0;
  mSchemaAusnahmen8 = "";
  mSchemaAusnahmen4 = "";
  mVersionen.resize(0); // Default-Versionen werden erst am Ende erzeugt, falls
  			// dann immer noch mVersionen.size() = 0 ist
  mAnimEinspruenge.resize(0);
  mAnimFolgen.resize(1);  // Keine Animationen; AnimFolgen muss auf jeden Fall
  mAnimFolgen[0].mDatei = 0;  // am Anfang einen . haben.
  mAnimFolgen[0].mPos = '.';
  mVersionNachKette = false;  // Default: Vers. nicht aus Kettenl. berechnen
  /* Default: Mit Rndern verbinden? */
  for (int i = 0; i < 4; i++)
    mVerbindetMitRand[i] = vmr;
  mKetteZaehltNurInnen = false;
  mKleidsam = false;       // Zunchst verkleiden sich die Blops noch nicht
  // (Wird von ParseBPtr ggf. auf true gesetzt)
  		
  loeschBilder(); // Alte Bilder lschen
  	
  mSyncAnimZust = BlopZustand(-1);	// Animationszustand fr sync-Animation
  // initialisieren. (version = -1 bedeutet, dass der BlopZustand nicht
  // wirklich zu einem Blop gehrt)
  																
  /* Abschnitt zwischenabspeichern und zu unserem Abschnitt gehen.
     (Beim Destructor
     wird wieder auf den alten Abschnitt zurckgeschaltet) */
  ConfigAbschnittPush cap(*ld->mLevelConf, name);
  	    	
  /* Gibt es zu diesem Bildchen berhaupt einen Abschnitt in
     der Config-Datei? */
  if (cap.hatGeklappt()) {
    /* OK, es gibt in der Gruppe mit diesem Namen einen pics-Eintrag;
       also gibt's insbesondere diese Gruppe... */

    if (verbart != verbart_nein) {
      /* Wenn's bei dieser Art Bildchen Sinn macht: Schema lesen (optional) */
      mSchema = ld->mLevelConf->getZahlEintrag("schema", mSchema);

      /* Schema-Ausnahmen lesen (optional) */
      __String a1 = ld->mLevelConf->getEintrag("exception1");
      if (!a1.isEmpty()) mSchemaAusnahme1 = a1[0];
      mSchemaAusnahmen8 =
	ld->mLevelConf->getEintrag("exceptions8", mSchemaAusnahmen8);
      mSchemaAusnahmen4 =
	ld->mLevelConf->getEintrag("exceptions4", mSchemaAusnahmen4);
  			
      /* Verbindet-mit-Rand lesen (optional) */
      if (ld->mLevelConf->hatEintrag("connecttoborder")) {
	
	for (int i = 0; i < 4; i++)
	  mVerbindetMitRand[i] = false;

	__String raender =
	  ld->mLevelConf->getEintrag("connecttoborder");

	for (int j = 0; j < (int) raender.length(); j++) {
	  switch (raender[j]) {
	  case 't': mVerbindetMitRand[rand_oben] = true; break;
	  case 'b': mVerbindetMitRand[rand_unten] = true; break;
	  case 'l': mVerbindetMitRand[rand_links] = true; break;
	  case 'r': mVerbindetMitRand[rand_rechts] = true; break;
	  default: throw Fehler(_("Wrong letter in connecttoborder"));
	  }
	}
      }
    } // Ende von: Schema lesen
  		
    /* Andere Nachbarschaft als level-weite globale? (optional) */
    mNachbarschaft =
      ld->mLevelConf->getZahlEintrag("neighbours", mNachbarschaft);
    if (mNachbarschaft < 0 || mNachbarschaft > nachbarschaft_letzte)
      throw Fehler(_("neighbours out of range"));

    /* Ketten zhlen nur innen? (optional, z. B. Go-Level) */
    mKetteZaehltNurInnen =
      ld->mLevelConf->getZahlEintrag("onlyinterior", mKetteZaehltNurInnen);
    			
    /* Bilder laden... */
    QStrList namen;
    int anz_bi = ld->mLevelConf->getListenEintrag("pics", namen);
    if (anz_bi < 1)
      throw Fehler(_("#pics < 1"));
    mBilddateien.resize(anz_bi);

    /* Falls ein Throw whrend des Ladens der Bilder kommt, ist das Array
       erst halb gefllt. Damit es spter richtig gelscht werden kann,
       sollten nicht existente Bilder 0-Pointer sein... */
    for (int i = 0; i < anz_bi; i++)
      mBilddateien[i] = 0;

    __String bild_name;
    int bnr = 0;
    for (bild_name = namen.first(); bild_name != 0;
	 bild_name = namen.next(), bnr++) {
      //Bilddatei * neu_b = new Bilddatei();
      //neu_b->laden(bild_name);
      //mBilddateien[bnr] = neu_b;
      mBilddateien[bnr] = new Bilddatei();
      mBilddateien[bnr]->laden(bild_name);
    }
    
    /* Springer-Striche-Bildchen laden (optional, z. B. Schach-Level) */
    if (ld->mLevelConf->hatEintrag("knightlines")) {
      mSpringerStriche = new Bilddatei();
      mSpringerStriche->laden(ld->mLevelConf->getEintrag("knightlines"));
    }
    	
    /* Versionen laden */
    if (ld->mLevelConf->hatEintrag("versions")) {
      int akt_dat = 0;
      __String vers = ld->mLevelConf->getEintrag("versions");
      const char * s = (const char *) vers;
      parseBPtrFolge(mVersionen, s, akt_dat);
    }
    	
    /* Animationen laden */
    if (ld->mLevelConf->hatEintrag("animations")) {
      int akt_dat = 0;
      __String anim = ld->mLevelConf->getEintrag("animations");
      const char * s = (const char *) anim;
    		
      /* So lange der Animations-String noch nicht leer ist, Animationen
	 parsen. */
      while (*s) {
    		
	int parTime = 1;
	Menge parVers(true);
	Menge parPos(true);
	bool parSync = false;
    			
	/* "Parameter" fr die Animation parsen? */
	if (parseBuch(s, '[')) {
    			
	  do {
	    char par = parseParGleich(s);
	    if (!par)
	      throw Fehler(_("In animations: '<letter>=' expected, but not found."));
    					
	    switch (par) {
	    case 't':
	      parTime = parseZahl(s, 0);
	      if (parTime == 0) {
		__String w = parseWort(s);
		if (w == "turn")
		  parTime = animzeit_drehen;
		else
		  throw Fehler(_("In animations: Expected number or turn after t="));
	      }
	      break;
	    case 'v':
	      parVers = parseMenge(s);
	      break;
	    case 'p':
	      parPos = parseMenge(s);
	      break;
	    case 's':
	      parSync = parseZahl(s, 1);
	      break;
	    default:
	      throw Fehler(_("In animations: Nonexistent parameter. (Parameters = tvps)"));
	    }
    					
    					
	  } while (parseKommaKlammer(s, ']'));
    			  				
	}  	// Ende: if es gibt Paramter zu parsen
    		
	/* Neuen Einsprung erzeugen */
	int si = mAnimEinspruenge.size();
	ASSERT(mAnimEinspruenge.resize(si + 1));
	mAnimEinspruenge.insert(si,
				new AnimEinsprung(mAnimFolgen.size(), parTime, parVers, parPos, parSync));
    			
	/* Default-drbermalwert fr Buchstaben ist
	   true, wenn die Versionsmenge oder die SchePo-Menge mehr als
	   einelementig sind. Wenn die Gesamtzahl der Versionen noch 0 ist, wird
	   sie (da es eine Animation gibt) zu 1 defaulten. Fr die schePo-Menge
	   wird der Einfachheit halber davon ausgegangen, dass sie einelementig
	   ist, genau dann, wenn es entweder eh keine Verbindungen gibt oder
	   wenn sie explizit einelementig gemacht wurde. */
	int anzVers = mVersionen.size();
	if (!anzVers) anzVers = 1;
	bool vm_gross = parVers.groesse(anzVers - 1 + 'A') > 1; // provisorisch!!
	bool pm_gross = verbindbar() && parPos.groesse() > 1;
	/* Eigentliches Folge-Parsen */
	parseBPtrFolge(mAnimFolgen, s, akt_dat, vm_gross || pm_gross);
  		  		  		
	/* Null-Pointer in Folge einfgen als Marker fr Animations-
	   folgen-Ende */
	int as = mAnimFolgen.size();
	mAnimFolgen.resize(as + 1);
	mAnimFolgen[as] = BildchenPtr();
      }
    }

    /* Versionen kettenabhngig? (optional) */
    mVersionNachKette = ld->mLevelConf->getZahlEintrag("versionbychain", 0);
  		
  		
  		  					
    /* Ende: In Config existiert Abschnitt fr dieses Bildchen */
  } else {
    /* Kein Abschnitt in der Config fr dieses Icon. Also direkt den Namen
       als Bilddateinamen verwenden */
    mBilddateien.resize(1);
    Bilddatei * neu_b = new Bilddatei();
    neu_b->laden(name);
    mBilddateien[0] = neu_b;
    
    /* Wenn es nur ein Bildchen ist, dann nicht verbinden */
    if (mBilddateien[0]->anzBildchen() == 1) {
      mSchema = schema_einbild;
    }
  }

  /* Keine Versionen definiert? Dann default-Version(en) erzeugen:
     Wenn es Animationen gibt,
     dann auf jeden Fall nur eine. Sonst: Bei verbindbarer Sorte
     eine pro Datei, sonst eine pro Bildchen */
  if (mVersionen.isEmpty()) {
    if (mAnimEinspruenge.isEmpty()) {
      /* Keine Animationen... */
      if (verbindbar()) {
	/* Verbindbar, also eine Version pro Datei */
	mVersionen.resize(mBilddateien.size());
	for (int i = 0; i < (int) mVersionen.size(); i++)
	  mVersionen[i] = BildchenPtr(i, '*');
      } else {
	/* Nicht verbindbar, also eine Version pro Bildchen in erster Datei */
	mVersionen.resize(mBilddateien[0]->anzBildchen());
	char v; int i;
	for (i = 0, v = 'A'; i < (int) mVersionen.size(); i++, v == 'Z' ? v = 'a' : v++)
	  mVersionen[i] = BildchenPtr(0, v);
      }
    } else {
      /* Mit Animationen; also default nur eine Version */
      mVersionen.resize(1);
      mVersionen[0] = BildchenPtr(0, '*');
    }
  } // Ende: Default fr Versionen setzen

}


/** Sollte einmal pro Spielschritt aufgerufen werden (bevor
    Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich ggf. um
    die Synchron-Animation */
void Sorte::spielSchritt() const {
  animiereIntern(mSyncAnimZust);
}


/** Liefert ein BildchenPtr zum aktuellen Bildchen aus der Animation
    (damit die ganzen Animations-Zusatzinformationen ausgelesen werden
    knnen). Liefert 0-Ptr bei keiner Animation. */
BildchenPtr Sorte::getAnimBPtr(const BlopZustand & zust) const {
  if (zust.mAnimNr == -1)
    return BildchenPtr();
  else return mAnimFolgen[zust.mAnimPos];
}


/** ndert die Variable zust zum nchsten Animationsschritt. (Evtl. wird
    einfach der Zustand der Synchron-Animationsvariable nach zust kopiert.)
*/
void Sorte::animiere(BlopZustand & zust) const {
  /* Gibt es eine Synchron-Animation... */
  if (mSyncAnimZust.mAnimNr != -1) {
    /* ..., die zu unserem Blop passt? */
    if (mAnimEinspruenge[mSyncAnimZust.mAnimNr]->animPasst(zust)) {
      /* Dann hat die Vorrang */
      zust.mAnimNr = mSyncAnimZust.mAnimNr;
      zust.mAnimPos = mSyncAnimZust.mAnimPos;
      zust.mVerzoegert = mSyncAnimZust.mVerzoegert;
      return;
    }
  }
  /* OK, keine Synchron-Animation. Also selbst animieren. Achtung: Es kann
     passieren, dass im vorigen Schritt der Blop noch zur Synchron-Animation
     gepasst hat, und jetzt nicht mehr. Dann macht er auf eigene Faust jetzt
     erst mal die aktuelle Animationsfolge trotzdem fertig.
     Bug: Das kann dazu fhren, dass dieser Blop einen anderen anzndet, obwohl
     er das gar nicht mehr kann. */
  animiereIntern(zust);
}  // animiere


/** Interne Version von animiere(); berechnet nur den neuen Wert von anim */
void Sorte::animiereIntern(BlopZustand & zust) const {
	
  if (zust.mAnimNr != -1) {
    /* Animation luft noch */

    /* Animation um ein Bildchen verzgern? */
    if (zust.mVerzoegert) {
      zust.mVerzoegert = false;
      return;
    }

    zust.mAnimPos++;
    /* Animation beenden? (Ende der Animation ist durch Null-Pointer markiert) */
    if (!mAnimFolgen[zust.mAnimPos]) {
      zust.mAnimNr = -1;
      zust.mAnimPos = 0;
    }
  }
  	  	  	  	
  /* Wenn keine Animation luft, evtl. neue starten */
  for (int i = 0; i < (int) mAnimEinspruenge.size() && zust.mAnimPos == 0; i++) {
    zust.mAnimPos = mAnimEinspruenge[i]->starteVielleichtAnim(zust);
    if (zust.mAnimPos) zust.mAnimNr = i;
  }	
 				  		
}  // Ende: animiereIntern(...)

/** Startet die Sonder-Animation san, so sie existiert. (Mit Verzgerung!) */
void Sorte::starteSonderAnim(BlopZustand & zust, int san) const {
  for (int i = 0; i < (int) mAnimEinspruenge.size(); i++)
    if (mAnimEinspruenge[i]->mAnimZeit == san) {
      zust.mAnimPos = mAnimEinspruenge[i]->mEinsprung;
      zust.mAnimNr = i;
      /* Auch das erste Bildchen noch sehen: */
      zust.mVerzoegert = true;
      return;
    }
}


/** liefert die Nr. eines Bildchens, die der Buchstabe c
in level.descr bedeutet, zurck */
int Sorte::bildchenNr(char c) const {

  if (c >= 'A' && c <= 'Z') {
    return c - 'A';
  } else if (c >= 'a' && c <= 'z') {
    return c - 'a' + 26;
  } else {
    __String s;
    s.sprintf(_("Error: Wrong icon letter (%c) somewhere in %s\n"), c, "level.descr");
    fprintf(stderr, s.data());
    return 0;
  }
}


/** Malt ggf. einen Springerstrich.
    stueck: Bit 0 und 1 geben Bildchen-Nr an.
    Bit 2 gesetzt bedeutet linker/oberer Teil vom Strich in
    rechten/unteren Teil vom Bildchen malen. */
void Sorte::malSpringerStrich(QPainter & p, int xx, int yy,
                                  int stueck) const {
  if (mSpringerStriche) {
    int bi = stueck & 3;
    /* hauptrichtung: 1 = eher waagrecht, 2 = eher senkrecht */
    int hauptrichtung = bi == 0 || bi == 3 ? 1 : 2;
    int vie = 0;
    if (stueck & 4) {
      if (hauptrichtung == 1) yy += gric / 2; else xx += gric / 2;
    } else {
      vie = 3 - hauptrichtung;
    }
    mSpringerStriche->malBildchen(p, xx, yy, bi, vie);
    if (hauptrichtung == 1) xx += gric / 2; else yy += gric / 2;
    vie += hauptrichtung;
    mSpringerStriche->malBildchen(p, xx, yy, bi, vie);
  }
}


/** malt einen Blop; xx und yy sind in Pixeln angegeben.
    Verbindung gibt an, wo nachbarblops sind; zust gibt den Zustand
    des Blops (Animationsstand und Version) an.
    Bei der Gelegenheit wird zust.mBenutzteSchemaPos aktualisiert. */
void Sorte::malen(QPainter & p, int xx, int yy,
		  const BlopZustand & zust, int verbindung) const {

  /* Bits an Spiegelung anpassen */
  if (ld->mSpiegeln) {
#define TAUSCH_BITS(b1, b2) if ((verbindung & b1+b2) != 0 && (verbindung & b1+b2) != b1+b2) verbindung ^= b1+b2;
    TAUSCH_BITS(verbindung_oben, verbindung_unten);
    TAUSCH_BITS(verbindung_lo, verbindung_lu);
    TAUSCH_BITS(verbindung_ro, verbindung_ru);
#undef TAUSCH_BITS
  }

  /* Fr die Animation zust.mBenutzteSchemaPos aktualisieren; dazu erst mal
     leeren. malAnimiertesBildchen fgt dann das richtige wieder ein. */
  zust.mBenutzteSchemaPos.dazu('A', 'z', false);

	
  /*#define verbindung_rechts 0x0001
    #define verbindung_links  0x0002
    #define verbindung_unten  0x0004                 5 3 7
    #define verbindung_oben   0x0008                 1 9 0
    #define verbindung_lu     0x0010                 4 2 6
    #define verbindung_lo     0x0020
    #define verbindung_ru     0x0040
    #define verbindung_ro     0x0080
    #define verbindung_solo   0x0100*/
  
  /* Handelt es sich um ein Solo-Blop und gibt es dafr eine Ausnahme? */
  if (verbindung == verbindung_solo && mSchemaAusnahme1) {
    malAnimiertesBildchen(p, xx, yy, zust, mSchemaAusnahme1);
    return;
  }

  /* Gibt es deckende 8-Nachbarn-Ausnahmen? Dann malen und fertig. */
  if (malAusnahmen8(p, xx, yy, zust, verbindung, true))
    return;


  /* Normales (schema-abhngiges) Bildchen: */
  switch (mSchema) {
	
  case schema_keins:
    throw Fehler(_("Error in level.descr: No schema and not enough exceptions8.\n"));
	
  case schema_normal:
    // Normale Verbindungen
    malAnimiertesBildchen(p, xx, yy, zust, "ABDCEFHGMNPOIJLK"[verbindung & 15]);
    break;
		
  case schema_viertel: {
    // Viertelmodus-Verbindungen
	
    /* Die vier Viertel durchgehen */
    for (int dx = 0; dx < 2; dx++)
      for (int dy = 0; dy < 2; dy++) {
	int vnr = dx + 2 * dy;
	int bnr = getEckVerbindung(verbindung, vnr, ev_lo_ru);
					
	/* Jetzt gibt bnr an, von welchem verschobenen Bildchen aus dem
	   xpm ein Viertel genommen werden muss. Allerdings noch ziemlich
	   durcheinander. Daraus die Koordinaten ausrechnen; dabei bedeutet
	   (0,0) das, was links oben nur noch viertel im Bild ist */
	int bx = "0013330202111322"[bnr] - '0';
	int by = "0303012310321212"[bnr] - '0';
	
	/* Wenn wir das rechte untere Viertel vom verschobenen Bildchen malen
	   wollen wrden (d. h. das li.ob. vom Zielbildchen), wren das schon
	   die richtigen Koordinaten; sonst noch leicht verndern... */
	if (dx) bx = (bx + 3) % 4;
	if (dy) by = (by + 3) % 4;
				
	/* Daraus die Nummer fr die bergabe an malBildchenStueck berechnen
	   (wird dort dann zurckgerechnet; wie bldsinnig, aber man will
	   ja konsistent bleiben... */
	malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
			      zust, 'A' + bx + 4 * by, vnr);
      }
    break;
  }
  case schema_minimal: {
    /* Die vier Viertel durchgehen */
    for (int dx = 0; dx < 2; dx++)
      for (int dy = 0; dy < 2; dy++) {
	int vnr = dx + 2 * dy;
				
	/* Berechnen, aus welchem Bildchen ein Viertelchen genommen wird */
	int bnr =
	  ( dx  ?  !(verbindung & verbindung_rechts)  :
	    !!(verbindung & verbindung_links) ) +
	  2 * ( dy  ?  !(verbindung & verbindung_unten)  :
		!!(verbindung & verbindung_oben) );
	malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
			      zust, 'A' + bnr, vnr);
      }
    break;
  }
  
  case schema_schraeg_minimal: {
    /* Die vier Viertel durchgehen */
    for (int dx = 0; dx < 2; dx++)
      for (int dy = 0; dy < 2; dy++) {
	int vnr = dx + 2 * dy;
        /* Das 2. Bildchen genau dann nehmen, wenn schrg ein passendes ist */
        int bnr = !!(verbindung & (1 << (5 + 2 * dx - dy)));
        malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
                              zust, 'A' + bnr, vnr);
      }    
    break;
  }

  case schema_einbild:
    malAnimiertesBildchen(p, xx, yy, zust, 'A');
    break;

  case schema_sechseck: {
    /* Die vier Viertel durchgehen */
    for (int dy = 0; dy < 2; dy++)
      for (int dx = 0; dx < 2; dx++) {
	int vnr = dx + 2 * dy;
	int bx = (dx ?
		  "3120"[!!(verbindung & verbindung_ro) +
			2 * !!(verbindung & verbindung_ru)]
		  :
		  "0321"[!!(verbindung & verbindung_lo) +
			2 * !!(verbindung & verbindung_lu)]
		  ) - '0';
	int by = dy ? !(verbindung & verbindung_unten) :
	  !!(verbindung & verbindung_oben);
	if (bx & 1) {
	  vnr ^= 2;
	  if (dy) by ^= 1;
	}
	malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
			      zust, 'A' + bx + 4 * by, vnr);			
      }
    break;
  }
    
  case schema_mauer: {
    /* _   _
     *    |_|
     *|  _    */

    /* Die vier Viertel durchgehen */
    for (int dy = 0; dy < 2; dy++)
      for (int dx = 0; dx < 2; dx++) {
	int vnr = dx + 2 * dy;
	int na = getEckVerbindung(verbindung, vnr, ev_lmr);
	/* na enthlt die relevanten Nachbarn fr unser Viertel. */

	/* Beide Nachbarwnde? */
	char bnr;
	if ((na & 5) == 0)
	  bnr = 'C';
	else {
	  /* Erst mal alles irgendwie zyklisch rechnen (znr). Annahme: Linkes
	     oberes Viertel, Feld mit bnr = 0 habe znr = 0. */
	  int znr;
	  if ((na & 1) == 0) znr = 3; // Linke Wand
	  else if ((na & 4) == 0) znr = 0; // Obere Wand
	  else if ((na & 2) == 0) znr = 1; // Eckstck
	  else znr = 2; // Nix
	  /* Zyklisch nummerierte Eck-Nr addieren. (Dazu 2 und 3
	     vertauschen.) */
	  znr = (znr + (vnr < 2 ? vnr : 5 - vnr)) % 4;
	  /* In echte Bild-Nr umrechnen */
	  bnr = "ABED"[znr];
	}

	//int bx = "0013330202111322"[bnr] - '0';

	malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
			      zust, bnr, vnr);			
      }
    break;
  }
  } // switch (mSchema)
		
  /* Gibt es Eck-Ausnahmen? */
  /* Die vier Viertel durchgehen */
  for (int dx = 0; dx < 2; dx++)
    for (int dy = 0; dy < 2; dy++) {
      int vnr = dx + 2 * dy;
      int ev = getEckVerbindung(verbindung, vnr, ev_lo_ru);
      /* Passt das zu einer Ausnahme? */
      for (int i = 0; i < (int) strlen(mSchemaAusnahmen4); i += 7) {
	/* Ausnahme analysieren */
	int u = 0, c = 0;
	for (int j = 4; j--;) {
	  u *= 2;
	  c *= 2;
	  if (mSchemaAusnahmen4[i+j] == '0') u++;
	  else if (mSchemaAusnahmen4[i+j] == '1') u++,c++;
	  else if (mSchemaAusnahmen4[i+j] != '?') printf(_("Error in level.descr: exceptions4\n"));
	}
				
	if ((ev & u) == c) {
	  /* Ja, passt */
	  malAnimiertesBildchen(p, xx + gric/2*dx, yy + gric/2*dy,
				zust, mSchemaAusnahmen4[i+5], vnr ^ 3);
	}
      } // for i
    }	// for dx, dy


  /* Evtl. noch nicht-deckende 8-Nachbarn-Ausnahmen malen. */
  malAusnahmen8(p, xx, yy, zust, verbindung, false);
} // malen



/** 8-Nachbar-Ausnahmen mssen zweimal gemalt werden:
    - Am Anfang von malen() die deckenden; wenn eine passende deckende
    existiert, liefert malAusnahmen8 true zurck, und es muss nix weiteres
    mehr gemalt werden.
    - Am Ende von malen() die nicht deckenden.
    */
bool Sorte::malAusnahmen8(QPainter & p, int xx, int yy,
			  const BlopZustand & zust,
			  int verbindung,
			  bool deckende_malen) const {
  /* Ausnahmen durchgehen */
  for (int pos = 0; pos < (int) strlen(mSchemaAusnahmen8); ) {
    int u = 0, c = 0;
    for (int j = 8; j--;) {
      u *= 2;
      c *= 2;
      /* Die nachfolgende Lookup-Tabelle gibt zu jedem Bit aus verbindung
	 an, wo im exceptions-String es ist (Im Exception-String stehen die
	 Bits im Uhrzeigersinn; erstes Zeichen steht fr oben) */
      char b = mSchemaAusnahmen8[pos + "26405731"[j] - '0'];
      if (b == '0') u++;
      else if (b == '1') u++,c++;
      else if (b != '?')
	fprintf(stderr, _("Error in level.descr, exceptions8: 0, 1 or ? expected\n"));
    }
    /* OK, 01?-Kette abgehakt */
    pos += 8;
    /* Danach ":"? */
    if (mSchemaAusnahmen8[pos++] != ':')
      fprintf(stderr, _("Error in level.descr, exceptions8: : expected\n"));

    /* Ausnahme-Schemapos lesen */
    char sp = mSchemaAusnahmen8[pos++];

    /* Drbermal-Ausnahme? */
    bool druebermalen = mSchemaAusnahmen8[pos] == '+';
    if (druebermalen)
      pos++;

    /* OK, wollen wir diese Ausnahme jetzt malen? D. h.:
       Passt sie und hat sie die richtige Deckkraft? */
    if ((verbindung & u) == c && druebermalen != deckende_malen) {

      malAnimiertesBildchen(p, xx, yy, zust, sp);
      /* Deckend? Dann sind wir fertig. */
      if (deckende_malen)
	return true;
    }

    /* Komma berspringen */
    pos++;
  }

  /* Keine deckende 8-Ausnahme gemalt. */
  return false;
}


/** Malt das / die Bildchen passend zu zust und der Schemaposition.
    viertel gibt an, welches Viertel gemalt werden soll. */
void Sorte::malAnimiertesBildchen(QPainter & p, int xx, int yy,
				  const BlopZustand & zust,
				  char schepo, int viertel) const {

  /* . = gar nix malen */
  if (schepo == '.')
    return;
															 	
  /* Fr die Animation zust.mBenutzteSchemaPos aktualisieren */
  zust.mBenutzteSchemaPos.dazu(schepo);
	
  /* Standard-Bildchen raussuchen: */
  BildchenPtr bp = mVersionen[zust.mVersion];
	
  /* Animationsbildchen raussuchen: */
  BildchenPtr abp;
  if (zust.mAnimNr != -1  &&
      mAnimEinspruenge[zust.mAnimNr]->mSchemaPos.drin(schepo))
    abp = mAnimFolgen[zust.mAnimPos];
  else
    abp = BildchenPtr(0, '.');
 	
  /* Erst mal das Originalbildchen malen. Auer, wenn das Animationsbilchen
     nicht will, dass es untermalt wird. */
  if (abp.mDrueberMalen)
    malBPtr(p, xx, yy, bp, schepo, viertel);
 		
  /* Und jetzt das Animationsbildchen drbermalen */
  malBPtr(p, xx, yy, abp, schepo, viertel);
}

/** Malt das Bildchen, dass von bp angegeben wird.
    Insbesondere wird bei * schepo gemalt und bei . nichts.
    viertel gibt an, welches Viertel gemalt werden soll. */
void Sorte::malBPtr(QPainter & p, int xx, int yy, BildchenPtr bp,
		    char schepo, int viertel) const {
  if (bp.mPos == '*')
    mBilddateien[bp.mDatei]->malBildchen(p, xx, yy,
					 bildchenNr(schepo), viertel);
  else if (bp.mPos != '.')
    mBilddateien[bp.mDatei]->malBildchen(p, xx, yy,
					 bildchenNr(bp.mPos), viertel);
}


/** extrahiert aus einer bergebenen Verbindung die vier
    Berhrviertel der angegebenen Ecke und speichert sie
    in die vier ersten Bits des Rckgabewerts. Verschiedene
    Speicheranordnungen knnen angegeben werden. */
int Sorte::getEckVerbindung(int verbindung, int vnr,
			    int * anordnung) const {
	
  int ret = 0, t = anordnung[vnr];
  for (int i = 0; i < 4; i++) {
    int a = t % 10;
    ret *= 2;
    if (a == 9 || (verbindung & (1 << a)) != 0)
      ret++;
    t /= 10;
  }
  return ret;
}

/** liefert true, wenn diese Blopsorte Verbindungen eingehen kann */
bool Sorte::verbindbar() const {
  return mSchema != schema_einbild  ||
    !mSchemaAusnahmen4.isEmpty()  ||
    !mSchemaAusnahmen8.isEmpty();
}

/** Prft, ob als nchstes b kommt. b wird ggf. weggeparst. */
bool Sorte::parseBuch(const char * & str, char b) const {
  if (*str == b) {
    str++;
    return true;
  }
  return false;
}

/** Parst X= (fr X Buchstabe). Liefert 0 zurck, wenn da kein Buchstabe steht.
    Sonst: Liefert X als Kleinbuchstabe. */
char Sorte::parseParGleich(const char * & str) const {
  char b = *str;
  if (b >= 'A' && b <= 'Z')
    b += 'a' - 'A';
  if (b < 'a' || b > 'z')
    return 0;
	
  str++;
  parseBuch(str, '=');
	
  return b;
}

/** Erwartet ein "," oder ein kl; liefert true bei "," */
bool Sorte::parseKommaKlammer(const char * & str, char kl) const {
  if (parseBuch(str, ',')) return true;
  if (!parseBuch(str, kl)) {
    char s[1111];
    sprintf(s, _("In animations: '%c' or ',' expected. Found '%c' instead."), kl, *str);
    throw Fehler(s);
  }
  return false;	
}

/** Parst eine Zahl >= 0. Liefert def, wenn da keine Zahl stand. */
int Sorte::parseZahl(const char * & str, int def /*= -1*/) const {
  bool neg = parseBuch(str, '-');
  if (*str >= '0' && *str <= '9') {
    int ret = 0;
    while (*str >= '0' && *str <= '9')
      ret = 10 * ret + *str++ - '0';
    return neg ? -ret : ret;
  }	else
    return def;
}

/** Parst ein Wort (aus Buchstaben und _) und liefert es in
    Kleinbuchstaben zurck */
__String Sorte::parseWort(const char * & str) const {
  __String ret = "";
  while (*str >= 'A' && *str <= 'Z'  ||
	 *str >= 'a' && *str <= 'z'  ||
	 *str == '_') {
    ret += *str >= 'A' && *str <= 'Z' ? *str + 'a' - 'A' : *str;
    str++;
  }
  return ret;
}

/** Parst einen BildchenPointer aus dem String */
BildchenPtr Sorte::parseBPtr(const char * & str, int & akt_dat,
			     bool def_druebermal) const {
  BildchenPtr ret;
		
  /* Dateiwechsel? */
  akt_dat = parseZahl(str, akt_dat);
	
  ret.mDatei = akt_dat;
  if (*str >= 'A' && *str <= 'Z'  ||
      *str >= 'a' && *str <= 'z'  ||
      *str == '*'  ||  *str == '.')
    ret.mPos = *str++;
  else
    ret.mPos = 0; // Null-Pointer...
  /* Defaultwert fr Drbermalen */
  ret.mDrueberMalen = ret.mPos == '.'  ||
    ret.mPos != '*' && def_druebermal;
  /* Abweichungen vom Default-Drbermal */
  if (parseBuch(str, '-'))
    ret.mDrueberMalen = false;
  if (parseBuch(str, '+'))
    ret.mDrueberMalen = true;
	
  /* SonderDinge? */
  if (parseBuch(str, '(')) {
    do {
      char par = parseParGleich(str);
      switch (par) {
      case 'c': { /* Bei Anim: Change */
	__String w = parseWort(str);
	if (w == "end") {
	  ret.mVerwandlung = verwandlung_weg;
	} else if (w == "burn") {
	  ret.mVerwandlung = verwandlung_verbrenne;
	} else {
	  char s[1111];
	  sprintf(s, _("In Animations: Found c=%s. (Possible: end, burn)\n"),
		  w.data());
	  throw Fehler(s);
	}
	break;
      }
      case 'd': /* Bei Version: Disguise */
	if (*str < 'A' || *str >= 'A' + ld->mAnzFarben) {
	  char s[1111];
	  sprintf(s, _("In animations: expected kind-letter after d=. (Found %c)\n"),
		  *str);
	  throw Fehler(s);
	}
	ret.mVerkleidung = *str - 'A';
	mKleidsam = true;
	str++;
	break;
      case 'k': /* Bei Anim: New Kind */
	if (*str < 'A' || *str >= 'A' + ld->mAnzFarben) {
	  char s[1111];
	  sprintf(s, _("In animations: expected kind-letter after k=. (Found %c)\n"),
		  *str);
	  throw Fehler(s);
	}
	ret.mVerwandlung = verwandlung_sorte;
	ret.mVerwandlungParam = *str - 'A';
	str++;
	break;
      case 'p': /* Bei Version: Probability */
	ret.mHaeufigkeit = parseZahl(str, 0);
	break;
      case 'v': { /* Bei Anim: New Version */
	if (*str < 'A' || *str > 'Z') {
	  char s[1111];
	  sprintf(s, _("In animations: expected version-letter after v=. (Found %c)\n"),
		  *str);
	  throw Fehler(s);
	}
	ret.mVerwandlung = verwandlung_version;
	ret.mVerwandlungParam = *str - 'A';
	str++;
	break;
      }	
      case 'x': /* Bei Anim: Burn x */
	if (!ld->mMitFeuer)
	  throw Fehler(_("In animations: x= not allowed without fire\n"));
	ret.mZuendX = parseZahl(str, 0);
	ret.mFeuerVerbindbar = true;
	break;
      case 'y': /* Bei Anim: Burn y */
	if (!ld->mMitFeuer)
	  throw Fehler(_("In animations: y= not allowed without fire\n"));
	ret.mZuendY = parseZahl(str, 0);
	ret.mFeuerVerbindbar = true;
	break;
      }
    } while (parseKommaKlammer(str, ')'));
  }
	
	
  return ret;
}

/** Erwartet, dass da ein ";" oder ein Stringende steht; das ";" wird ggf.
    weggeparst */
void Sorte::parseSemikolon(const char * & str) const {
  if (!parseBuch(str, ';'))
    if (*str != 0) {
      char s[1111];
      sprintf(s, _("; or end of line expected. Found '%c' instead."), *str);
      throw Fehler(s);
    }
}

/** Parst eine Folge von BildchenPointern und schreibt sie hinters Array.
    Ein Semikolon am Ende wird auch mit weggeparst. def_druebermal gibt
    einen Defaultwert fr mDrueberMalen bei Buchstaben an. (Bei * und .
    ist der Default-Wert sowieso klar. */
void Sorte::parseBPtrFolge(QArray<BildchenPtr> & ar,
			   const char * & str, int akt_dat,
			   bool def_druebermal) const {
  //ar.clear();
  while (1) {
    BildchenPtr bp = parseBPtr(str, akt_dat, def_druebermal);
    if (!bp) break;
    int s = ar.size();
    ar.resize(s + 1);
    ar[s] = bp;
  }
  parseSemikolon(str);
}


/** Parst eine Menge von Buchstaben (A-Z, a-z). */
Menge Sorte::parseMenge(const char * & str) const {
  Menge r;
  bool inv = *str == '^';
  if (inv) str++;
  while (*str >= 'A' && *str <= 'Z'  ||
	 *str >= 'a' && *str <= 'z') {
    r.dazu(*str);
    str++;
  }
  if (inv) r.komplementiere();
	
  return r;
}


/** lscht die ganzen Bilder aus dem mBilddateien-Array */
void Sorte::loeschBilder() {
  for (int i = 0; i < (int) mBilddateien.size(); i++)
    if (mBilddateien[i])
      delete mBilddateien[i];
		
  /* Damit keine Pointer in der Luft hngen...: */
  mBilddateien.resize(0);
  
  /* Die Springerstriche lschen */
  if (mSpringerStriche) {
    delete mSpringerStriche;
    mSpringerStriche = 0;
  }
}


/** liefert die Anzahl der Versionen dieses Blops zurck. */
int Sorte::getAnzVersionen() const {
  return mVersionen.size();
}

/** Liefert eine zufllige Version mit der korrekten
    Wahrscheinlichkeitsverteilung
    (wie in level.descr angegeben) zurck. */
int Sorte::getZufallsVersion() const {
  int n = mVersionen.size();
  int k = 0;
  for (int i = 0; i < n; i++)
    k += mVersionen[i].mHaeufigkeit;
  ASSERT(k > 0);
  int r = rand() % k;
  int vnr = -1;
  while (r >= 0) {
    vnr++;
    r -= mVersionen[vnr].mHaeufigkeit;
  }
  return vnr;
}

/** Liefert die Blopsorte zurck, als die sich dieser Blop
    grade verkleidet. (Meistens verkleidung_keine) */
int Sorte::getVerkleidung(const BlopZustand & zust) const {
  return mVersionen[zust.mVersion].mVerkleidung;
}

/** Liefert true, wenn sich die Blops verkleiden knnen
    (und deshalb beim Versionswechsel auch Nachbarn
    neu gemalt werden mssen.) */
bool Sorte::getKleidsam() const {
  return mKleidsam;
}
