/***************************************************************************
                          leveldaten.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qbitmap.h>
#include <qpainter.h>

#include "cuyointl.h"

#include "fehler.h"

#include "pfaditerator.h"

#include "leveldaten.h"

/* Globale Variable mit den Level-Daten */

LevelDaten * ld;

/** */
LevelDaten::LevelDaten(): mLevelConf(0)
{
  ladLevelConf();
}


/** */
LevelDaten::~LevelDaten() {
  if (mLevelConf)
    delete mLevelConf;
}

void LevelDaten::ladLevelConf() {

  if (mLevelConf) {
    delete mLevelConf;
    mLevelConf = 0;
  }

  /* Level-descr-Datei ffnen; in verschiedenen Pfaden suchen...
     (Der Pfaditerator throwt ggf.)
     true bedeutet: Default-Pfad auf Ort der level.descr setzen. */
  PfadIterator pi("level.descr", true);
  for (; !QFile(pi.pfad()).exists(); ++pi);
  
  /* Pfad abspeichern fr schnere Fehlermeldungen */
  mLevelConfPfad = pi.pfad();
  
  /* Beim destructor von pi wird der Default-Pfad fr sptere
     Bildchen-Suche gesetzt. */

  mLevelConf = new ConfigDatei(mLevelConfPfad);
  mLevelConf->setEinSpielerVersion(false);
  mLevelConf->getListenEintrag("level", mIntLevelNamen);
}


/** fllt alle Daten in diesem Objekt fr Level nr aus; throwt bei Fehler */
void LevelDaten::ladLevel(int nr, int spz) {

  /* Nur fr den Fall eines frhen throws... */
  mLevelName = "";
  ASSERT(mLevelConf->setAbschnitt());
	
  try {

    /* Abschnitt auf diesen Level setzen */
    setLevelAbschnitt(nr);

    /* Spielerzahlabhngige Unterschiede bercksichtigen */
    mSpielerZahl = spz;
    mLevelConf->setEinSpielerVersion(spz == 1);
  	
    /* Level-Name */
    verlangeSchluessel("name");
    mLevelName = mLevelConf->getEintrag("name");

    /* Beschreibungstext (optional) */
    mBeschreibung = mLevelConf->getEintrag("description", "");

    /* Wie viele Steine mssen zusammen, damit sie platzen? */
    verlangeSchluessel("numexplode");
    mPlatzAnzahl = mLevelConf->getZahlEintrag("numexplode");
    if (mPlatzAnzahl < 1)
      throw Fehler(_("numexplode < 1"));

    /* Hintergrundfarbe... (optional; Default: wei)
       Achtung: Die Hintergrundfarbe muss gesetzt werden, _bevor_
       Bildchen geladen werden, da es als Bonus-Farbe im XPM
       "Background" gibt... (im Moment nur fr Explosion sinnvoll) */
    mHintergrundFarbe = mLevelConf->getFarbEintrag("bgcolor", __white);

    /* Hintergrundbilchen (optional) */
    mMitHintergrundbildchen = mLevelConf->hatEintrag("bgpic");
    if (mMitHintergrundbildchen)
      bhintergrund.laden(mLevelConf->getEintrag("bgpic"));

    /* Schriftfarbe... (optional; Default: schwarz) */
    schriftFarbe = mLevelConf->getFarbEintrag("textcolor", __black);

    /* Hetzrandfarbe... (optional; Default: hellgrau) */
    hetzrandFarbe = mLevelConf->getFarbEintrag("topcolor", __lightGray);

    /* Hetzrandgeschwindigkeit... */
    verlangeSchluessel("toptime");
    hetzrandZeit = mLevelConf->getZahlEintrag("toptime");
    if (hetzrandZeit < 1)
      throw Fehler(_("toptime < 1"));

    /* Hetzrandbildchen (optional) */
    mMitHetzbildchen = mLevelConf->hatEintrag("toppic");
    if (mMitHetzbildchen) {
      bhetz.laden(mLevelConf->getEintrag("toppic"));
  	
      /* Hetzrandberlapp (optional) */
      mHetzrandUeberlapp =
	mLevelConf->getZahlEintrag("topoverlap", bhetz.getHoehe());
    } else
      mHetzrandUeberlapp = 0;

    /* Gras nur bei Kettenreaktion? (optional) */
    mGrasBeiKettenreaktion = mLevelConf->getZahlEintrag("chaingrass", 0);

    /* Senkrecht spiegeln? (optional) */
    mSpiegeln = mLevelConf->getZahlEintrag("mirror");

    /* Andere Nachbarschaft? (optional) */
    mNachbarschaft =
      mLevelConf->getZahlEintrag("neighbours", nachbarschaft_normal);
    if (mNachbarschaft < 0 || mNachbarschaft > nachbarschaft_letzte)
      throw Fehler(_("neighbours out of range"));
    /* Sechseck-Raster? */
    mSechseck = mNachbarschaft == nachbarschaft_6 ||
      mNachbarschaft == nachbarschaft_6_schraeg;


    /* Zufllige Graue? (optional) */
    mZufallsGraue =
      mLevelConf->getZahlEintrag("randomgreys", zufallsgraue_keine);
  	
    /* Feuer (optional); Achtung: Muss vor allen anderen Bildchen
       geladen werden,
       die evtl. Feuer speien wollen knnten (damit diese Bildchen
       testen knnen,
       ob Feuer speien berhaupt erlaubt ist */
    mMitFeuer = mLevelConf->hatEintrag("firepic");
    if (mMitFeuer) {
      /* Feuerbildchen */
      mFeuerSorte.laden(mLevelConf->getEintrag("firepic"), verbart_ja);
    }

    /* Blschen (optional) */
    mMitBlaeschen = mLevelConf->hatEintrag("bubblespic");
    if (mMitBlaeschen)
      mBlaeschenSorte.laden(mLevelConf->getEintrag("bubblespic"), verbart_selten);
  	
    /* Leer-Bildchen (optional) */
    mMitLeerBildchen = mLevelConf->hatEintrag("emptypic");
    if (mMitLeerBildchen) {
      /* Letztes true: Per default mit Rand verbinden */
      mLeerSorte.laden(mLevelConf->getEintrag("emptypic"), verbart_ja, true);
    }

    /* Hidden Feature (optional) */
    mHiddenFeature = mLevelConf->getZahlEintrag("hiddenfeature", hifea_nix);

    /* Wie viele Farben gibts in diesem Level? Und wie heien die Bildchen? */
    QStrList namen;
    verlangeSchluessel("pics");
    mAnzFarben = mLevelConf->getListenEintrag("pics", namen);
    if (mAnzFarben < 1)
      throw Fehler(_("#pics < 1"));
  	
    if (mAnzFarben > max_farben_zahl) {
      __String s;
      s.sprintf(_("#pics > %d"), max_farben_zahl);
      throw Fehler(s);
    }

    /* Farb-Bilder laden */
    __String bild_name;
    int bnr = 0;
    for (bild_name = namen.first(); bild_name != 0; bild_name = namen.next(), bnr++)
      mFarbSorten[bnr].laden(bild_name, verbart_ja);

    /* Explosion laden. Das, was in explosion.xpm wei ist, muss
       Hintergrundfarbe bekommen. */
    //bbumm.ladenSpezial("explosion.xpm", hintergrundFarbe);
    bbumm.laden("explosion.xpm");
    		
    /* Grau-Bildchen laden */
    verlangeSchluessel("greypic");
    mGrauSorte.laden(mLevelConf->getEintrag("greypic"), verbart_selten);

    /* Grasbildchen laden */
    verlangeSchluessel("startpic");
    mGrasSorte.laden(mLevelConf->getEintrag("startpic"), verbart_selten);

    /* Wo sind welche Grasbildchen am Anfang? */
    verlangeSchluessel("startdist");
    mLevelConf->getListenEintrag("startdist", anfangszeilen);

    /* Drehwechsel (optional) */
    for (int i = 0; i < mAnzFarben; i++)
      mDrehWechsel[i] = i;
    if (mLevelConf->hatEintrag("turnchange")) {
      __String s = mLevelConf->getEintrag("turnchange");
      if ((int) s.length() != mAnzFarben)
	throw Fehler(_("turnchange has the wrong length"));
  		
      for (int i = 0; i < mAnzFarben; i++) {
	mDrehWechsel[i] = s[i] < 'a' ? s[i] - 'A' : s[i] - 'a';
	if (mDrehWechsel[i] < 0 || mDrehWechsel[i] >= mAnzFarben)
	  throw Fehler(_("Wrong letter in turnchange"));
      }

    }

  } catch (Fehler f) {
    __String fs;
    fs.sprintf(_("Error in \"%s\""),
	       mLevelConfPfad.data());
    if (!mLevelConf->getAbschnitt().isEmpty())
      fs += ", Section [" + mLevelConf->getAbschnitt() + "]";
    fs += ":\n" + f.mText + "\n";
    if (!mLevelName.isEmpty())
      fs += _("(Level \"") + mLevelName + _("\")\n");
    throw Fehler(fs);
  }
	
}





/** liefert zurck, wie viel Gras am Anfang des Levels
    da ist */
int LevelDaten::getGrasAnzahl() {
  int anz_grasfelder = 0;
  /* Zeilen durchgehen... */
  for (__String zeile = anfangszeilen.first(); zeile != 0; zeile = anfangszeilen.next()) {
    for (int x = 0; x < (int) zeile.length(); x++) {
      /* Etwas provisoritsch... */
      if (zeile.data()[x] >= 'A' && zeile.data()[x] <= 'Z')
	anz_grasfelder++;
    }
  }
  return anz_grasfelder;
}


/** Throwt, wenn der angegebene Schlssel in level.descr nicht existiert. */
void LevelDaten::verlangeSchluessel(const char * s) const {
  if (!mLevelConf->hatEintrag(s)) {
    __String t;
    t.sprintf(_("Key \"%s\" is missing"), s);
    throw Fehler(t);
  }
}

/** Sollte einmal pro Spielschritt aufgerufen werden (bevor
		Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich ggf. um
		die Synchron-Animation */
void LevelDaten::spielSchritt() const {
  for (int i = 0; i < mAnzFarben; i++)
    mFarbSorten[i].spielSchritt();
  mGrasSorte.spielSchritt();
  mGrauSorte.spielSchritt();
  if (mMitBlaeschen)
    mBlaeschenSorte.spielSchritt();
  if (mMitFeuer)
    mFeuerSorte.spielSchritt();
  if (mMitLeerBildchen)
    mLeerSorte.spielSchritt();
}


/** Liefert zurck, wie viele Level es gibt. */
int LevelDaten::getLevelAnz() const {
  return mIntLevelNamen.count();
}

/** Liefert den internen Namen von Level nr zurck. */
__String LevelDaten::getIntLevelName(int nr) const {
  return mIntLevelNamen.at(nr - 1);
}

/** Liefert den Namen von Level nr zurck. Liefert "???" bei Fehler. */
__String LevelDaten::getLevelName(int nr) const {
  try {
    setLevelAbschnitt(nr);

    verlangeSchluessel("name");
    return mLevelConf->getEintrag("name");

  } catch (Fehler f) {
    return "???";
  }
}


/* Setzt den akt. Abschnitt von mLevelConf auf Level nr. Throwt bei
   Fehler. */
void LevelDaten::setLevelAbschnitt(int nr) const {

  
  __String lna = nr == level_titel ? 
    "Title" :
    mIntLevelNamen.at(nr - 1);
  
  /* Gewnschten Abschnitt whlen */
  if (!mLevelConf->setAbschnitt(lna))
    throw Fehler(_("Section \"") + lna +
		 _("\" (Level ") + __String().setNum(nr) +
		 _(") doesn't exist."));
}
