/* term.h							-*- C++ -*-
   $Id: term.h,v 1.4 1998/09/07 00:49:40 elf Exp $
   
   written by Marc Singer
   27 Jul 1997

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1997,1998 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   Terminal abstractions routines.

*/

#if !defined (__TERM_H__)
#    define   __TERM_H__

/* ----- Includes */

#include "termcap.h"

typedef enum {
  attrBold		= 0x0001,
  attrUnderline		= 0x0002,
  attrInverse		= 0x0004,
  attrStandout		= 0x0008,
  attrBlink		= 0x0010,
  //  attrDim		= 0x0020,
  attrAllMode		= 0x003f,
  attrFgBright		= 0x0080,
  attrFgDefault		= 0x0000,	// Foreground colors
  attrFgMask		= 0x0f00,
  attrFgShift		= 8,
  attrFgFirst		= 0x0100,
  attrFgBlack		= 0x0100,
  attrFgRed		= 0x0200,
  attrFgGreen		= 0x0300,
  attrFgYellow		= 0x0400,
  attrFgBlue		= 0x0500,
  attrFgMagenta		= 0x0600,
  attrFgCyan		= 0x0700,
  attrFgWhite		= 0x0800,
  attrBgMask		= 0xf000, 	// Background colors
  attrBgShift		= 12,
  attrBgDefault		= 0x0000,
  attrBgFirst		= 0x1000,
  attrBgBlack		= 0x1000,
  attrBgRed		= 0x2000,
  attrBgGreen		= 0x3000,
  attrBgYellow		= 0x4000,
  attrBgBlue		= 0x5000,
  attrBgMagenta		= 0x6000,
  attrBgCyan		= 0x7000,
  attrBgWhite		= 0x8000,
} eAttribute;

/* ----- Classes */

class LTerm {
private:
  static Termcap g_termcap;

  char* m_pb;			// Buffer of pending output
  int m_cb;			// Amount of data pending for output
  int m_cbMax;			// Length of output buffer
  int m_fh;			// Output file handle

  unsigned16 m_attribute;	// Current display attribute

public:
  LTerm () {
    zero (); }
  ~LTerm () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (void);
  void release_this (void);

  void flush (void);

  Termcap& termcap (void) {
    return g_termcap; }

				// Informational methods
  int columns (void) {
    return g_termcap.num (termcapNumColumns); }
  int lines (void) {
    return g_termcap.num (termcapNumLines); }

				// Output queuing methods
  void cls (void) {
    m_cb += g_termcap.compose (termcapClearScreen, m_pb + m_cb); }
  void home (void) {
    m_cb += g_termcap.compose (termcapMoveHome, m_pb + m_cb); }
  void moveto (int line, int column) {
    m_cb += g_termcap.compose (termcapMoveTo, m_pb + m_cb, line, column); }
  void set_attribute (unsigned16 value, unsigned16 mask = ~0);
  int sprintf (char* pb, ...);

};

#endif  /* __TERM_H__ */
