import unittest
import sys

from ctypes import *

class Test(unittest.TestCase):

    def test_checkretval(self):
        class CHECKED(c_int):
            def _check_retval_(value):
                return str(value)
            _check_retval_ = staticmethod(_check_retval_)

        import _ctypes_test
        dll = CDLL(_ctypes_test.__file__)
        self.failUnlessEqual(42, dll._testfunc_p_p(42))

        dll._testfunc_p_p.restype = CHECKED
        self.failUnlessEqual("42", dll._testfunc_p_p(42))

        dll._testfunc_p_p.restype = None
        self.failUnlessEqual(None, dll._testfunc_p_p(42))

        del dll._testfunc_p_p.restype
        self.failUnlessEqual(42, dll._testfunc_p_p(42))

    try:
        oledll
    except NameError:
        pass
    else:
        def test_oledll(self):
            self.failUnlessRaises(WindowsError,
                                  oledll.oleaut32.CreateTypeLib,
                                  0, 0, 0)

if __name__ == "__main__":
    unittest.main()
