// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// event.h
//
// Changes:
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_EVENT_H
#define _INCLUDE_EVENT_H

#include "SDL.h"

#include "list.h"
#include "game.h"

// event types
#define EVENT_MESSAGE           1  // just show a message
#define EVENT_PRODUCTION        2  // set the unit or material production
                                   // of a building
#define EVENT_VICTORY		3  // the game ended last turn; just show
                                   // a victory/defeat message and exit
#define EVENT_SCORE		4  // raise the success rate of the player
#define EVENT_CREATE_UNIT	8  // create a unit for the current player

// event triggers
#define ETRIGGER_TURN           0x01
#define ETRIGGER_UNIT_DESTROYED 0x02
#define ETRIGGER_HAVE_BUILDING  0x04
#define ETRIGGER_HAVE_UNIT      0x08

class Event : public Node {
public:
  Event( SDL_RWops *file, Player **players );
  Event( unsigned char type, unsigned char trigger,
         short td1, short td2, short td3, short d1, short d2, short d3,
         short title, short msg, Player *player );
  int Save( SDL_RWops *file ) const;

  short Check( void );
  Event *Execute( class MessageWindow *msgwin, char **strings );

private:
  void DisplayMessage( class MessageWindow *win, const char * title,
                       const char *body ) const;

  unsigned char e_type;
  unsigned char e_trigger;

  short e_tdata[3];             // trigger data
  short e_data[3];              // event data

  short e_title;
  short e_message;

  Player *e_player;
};

#endif	/* _INCLUDE_EVENT_H */

