// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// button.h - button widget class
//
// Changes:
//   03-04-2001 - ButtonHook::Activate() now takes a pointer to
//                the button widget instead of its identifier
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_BUTTON_H
#define _INCLUDE_BUTTON_H

#include "widget.h"

class ButtonHook;

class ButtonWidget : public Widget {
public:
  ButtonWidget( short id, short x, short y, unsigned short w,
                unsigned short h, short key, unsigned short flags,
                const char *title, Window *window );
  virtual ~ButtonWidget( void );

  virtual void Draw( void );

  void SetHook( ButtonHook *hook ) { this->hook = hook; }
  void SetImage( Surface *image, const Rect &state1, const Rect &state2 );

  virtual GUI_Status MouseDown( const SDL_MouseButtonEvent &button );
  virtual GUI_Status MouseUp( const SDL_MouseButtonEvent &button );
  virtual GUI_Status KeyDown( const SDL_keysym &key );
  virtual GUI_Status KeyUp( const SDL_keysym &key );

  GUI_Status Activate( void );

protected:
  Image *image[2];
  ButtonHook *hook;
};

// hook class for button activation
class ButtonHook {
public:
  ButtonHook( void ) {}

  virtual GUI_Status Activate( ButtonWidget *button, Window *win ) = 0;
};


#define DEFAULT_CBW_SIZE 15

class CheckboxWidget : public ButtonWidget {
public:
  CheckboxWidget( short id, short x, short y, unsigned short w,
                unsigned short h, bool state, short key,
                unsigned short flags, const char *title, Window *window );

  GUI_Status MouseDown( const SDL_MouseButtonEvent &button );
  GUI_Status MouseUp( const SDL_MouseButtonEvent &button ) { return GUI_OK; }
  GUI_Status KeyDown( const SDL_keysym &key );
  GUI_Status KeyUp( const SDL_keysym &key ) { return GUI_OK; }
};


class MenuButtonWidget : public ButtonWidget {
public:
  MenuButtonWidget( short id, short x, short y, unsigned short w,
                unsigned short h, short key, unsigned short flags,
                const char *title, Window *window ) :
      ButtonWidget( id, x, y, w, h, key, flags, title, window ) {}

  virtual GUI_Status MouseMove( const SDL_MouseMotionEvent &move );
};

#endif	/* _INCLUDE_BUTTON_H */

