/*
** Copyright 2000-2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"cmlm.h"
#include	"cmlmstartmail.h"

#include	<fstream>

static const char rcsid[]="$Id: cmlmstartmail.C,v 1.4 2001/08/05 20:00:33 mrsam Exp $";

StartMail::StartMail(istream &m, const char *r): msg(m), verp_ret(r), n(0)
{
	recipients.SetSize(MAXRCPTS);
}

StartMail::~StartMail()
{
}

void StartMail::To(CString s)
{
	if (n >= MAXRCPTS)
		Send();
	recipients[n++]=s;
}

void StartMail::Send()
{
const char	*argvec[8];
CString	r;

	if (n == 0)	return;

	r=get_verp_return(verp_ret, 0);

	argvec[0]="sendmail";
	argvec[1]="-bcc";
	argvec[2]="-verp";
	argvec[3]="-f";
	argvec[4]=r;
	argvec[5]="-N";
	argvec[6]="fail";
	argvec[7]=0;

pid_t	p;
int	fd=sendmail(argvec, p);
afxopipestream ofs(fd);
size_t	i;
char	buf[BUFSIZ];

	for (i=0; i<n; i++)
		ofs << "Bcc: " << recipients[i] << endl;

	n=0;

	msg.clear();
	msg.seekg(0);
	msg.read(buf, sizeof(buf));

int	x;

	while ((x=msg.gcount()) > 0)
	{
		ofs.write(buf, x);
		msg.read(buf, sizeof(buf));
	}

	ofs.close();

int	rc=wait4sendmail(p);

	if (rc)	exit(rc);
}
