/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"liblock/config.h"
#include	"liblock/liblock.h"
#include	<fcntl.h>
#include	<unistd.h>

static const char rcsid[]="$Id: cmlm2.C,v 1.3 2000/09/16 21:37:20 mrsam Exp $";

ExclusiveLock::ExclusiveLock(const char *f) : fd(open(f, O_RDWR|O_CREAT, 0600))
{
	if (fd < 0)	return;

	ll_lock_ex(fd);
}

SharedLock::SharedLock(const char *f) : fd(open(f, O_RDWR|O_CREAT, 0600))
{
	if (fd < 0)	return;

	if (ll_lockfd(fd, ll_readlock|ll_whence_start|ll_wait, 0, 0) < 0)
		ll_lock_ex(fd);
		// Might be because shared locking is not supported

}

SharedLock::~SharedLock()
{
	if (fd >= 0)	close(fd);
}

ExclusiveLock::~ExclusiveLock()
{
	if (fd >= 0)	close(fd);
}

SubSharedLock::SubSharedLock() : SharedLock(SUBLOCKFILE)
{
}

SubSharedLock::~SubSharedLock()
{
}

SubExclusiveLock::SubExclusiveLock() : ExclusiveLock(SUBLOCKFILE)
{
}

SubExclusiveLock::~SubExclusiveLock()
{
}

CommandLock::CommandLock() : ExclusiveLock(CMDLOCKFILE)
{
}

CommandLock::~CommandLock()
{
}
