/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"courier.h"
#include	"rw.h"
#include	"comcargs.h"
#include	"afx.h"
#include	"afxtempl.h"
#include	<string.h>
#include	<signal.h>
#include	<stdlib.h>
#include	<stdio.h>

#if	HAVE_LOCALE_H
#include	<locale.h>
#endif

#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<iostream>
#include	<fstream>
#include	"dbobj.h"
#include	"aliases.h"

static const char rcsid[]="$Id: aliascreate.C,v 1.5 2001/08/05 20:00:33 mrsam Exp $";

using namespace std;

// MAXDUMP is the maximum # of addresses printed per list by the -dump
// flag.  Larger lists are printed in parts.  This allows the output
// of -dump to be refed into makealiases without using up a lot of memory.
//

#define	MAXDUMPCNT	(100-1)

static const char *srcfilename=0;
static const char *aliasfilename=0;
static const char *tmpfilename=0;
static const char *dumpflag=0;

static struct courier_args arginfo[]={
	{"src", &srcfilename},
	{"alias", &aliasfilename},
	{"tmp", &tmpfilename},
	{"dump", &dumpflag},
	{0}
	} ;

static void create_list(CStringList &addrlist, const char *listname,
	DbObj &newaliases, DbObj &workalias, DbObj &newindex)
{
AliasRecord	newaliases_buffer(newaliases);
AliasRecord	list_buffer(workalias);
AliasRecord	list_parent(workalias);
AliasRecord	dependencies(newindex);
AliasRecord	aux_keys2(newindex);
CString		addr;
int	firstdef;
CStringList	added_list, added_list2;
CMap<CString, CString, int, int> added_lookup, added2_lookup;
int	added_lookup_dummy=0;
POSITION	addpos;

POSITION	addrpos;
CString		sp;

	// Go through the list of addresses to add.

	list_buffer.Init(listname);
	firstdef=list_buffer.Init();

	// Step 1: adding addresses A1 .. An
	//
	// If Ax is itself a list, add Ax's members to the list of addresses
	// being added.
	//
	// For optimization purposes, the addresses that were actually added
	// (weren't in the list already) are saved to the list_added list.

	for (addrpos=addrlist.GetHeadPosition(); addrpos; )
	{
		sp=addrlist.GetNext(addrpos);

		list_parent.Init(sp);

	int	notfound=list_parent.Init();

		if (strcmp(sp, listname) == 0 || notfound)
		{
			// foo: foo is allowed
			if (!added_lookup.Lookup(sp, added_lookup_dummy))
			{
				added_list.AddTail(sp);
				added_lookup[sp]=1;

#if	ALIASES_DEBUG
cout << "List: " << listname << ", member " << sp << endl;
#endif
			}
		}

		addr='\n' + sp + '\n';

	size_t	dummy;
	char	*found=newindex.Fetch(addr, addr.GetLength(), dummy, 0);

		if (strcmp(sp, listname) == 0 || !found)
		{
			if (!added2_lookup.Lookup(sp, added_lookup_dummy))
			{
				added_list2.AddTail(sp);
				added2_lookup[sp]=1;
#if	ALIASES_DEBUG
cout << "List: " << listname << ", real member " << sp << endl;
#endif
			}
		}
		if (found)	free(found);

		newaliases_buffer.Init(sp);

		list_parent.StartForEach();
		while ( (const char *)(addr=list_parent.NextForEach()) != 0)
		{
			sp=addr;
			if (sp == listname)	continue;

			if (!added_lookup.Lookup(sp, added_lookup_dummy))
			{
				added_list.AddTail(sp);
				added_lookup[sp]=1;
#if	ALIASES_DEBUG
cout << "List: " << listname << ", member " << sp << endl;
#endif
			}
		}


		newaliases_buffer.StartForEach();
		while ( (const char *)
			(addr=newaliases_buffer.NextForEach()) != 0)
		{
			sp=addr;
			if (!added2_lookup.Lookup(sp, added_lookup_dummy))
			{
#if	ALIASES_DEBUG
cout << "List: " << listname << ", real member " << sp << endl;
#endif
				added_list2.AddTail(sp);
				added2_lookup[sp]=1;
			}
		}
	}

	list_buffer.Add(added_list, 1);

	newaliases_buffer.Init(listname);
	newaliases_buffer.Add(added_list2, 1);

	if (added_list.IsEmpty())	return;

	// Populate 'dependencies' with lists that include this
	// list, to which added_list addresses were just added.

	dependencies.Init(listname);
	dependencies.StartForEach();

	while ( (const char *)(addr=dependencies.NextForEach()) != 0)
	{
#if	ALIASES_DEBUG
cout << "Copying added members to: " << addr << endl;
#endif
		list_parent.Init(addr);

		if (firstdef)	list_parent.Delete(listname);
			// If this is the first listname definition, delete the
			// reference to the listname from the dependent
			// list's contents.

		list_parent.Add(added_list, 0);


		newaliases_buffer.Init(addr);
		newaliases_buffer.Add(added_list2, 0);
	}

	// Now, if we added address/list X to list Y, make sure X's
	// dependencies include all of Y's dependencies.

CStringList dependency_list;

	dependencies.StartForEach();
	dependency_list.AddTail(listname);

#if	ALIASES_DEBUG
cout << "Preparing to add dependencies: " << listname;
#endif
	while ( (const char *)(addr=dependencies.NextForEach()) != 0)
	{
		if (addr != listname)
		{
#if	ALIASES_DEBUG
cout << ", " << addr;
#endif
			dependency_list.AddTail(addr);
		}
	}
#if	ALIASES_DEBUG
cout << endl;
#endif

	for (addpos=added_list.GetHeadPosition(); addpos; )
	{
	CString	s(added_list.GetNext(addpos));

#if	ALIASES_DEBUG
cout << "... Added to " << s << endl;
#endif
		aux_keys2.Init(s);
		aux_keys2.Add(dependency_list, 0);
	}
	return;
}

static int add_aliases(istream &i, CString aliasname,
		DbObj &newaliases, DbObj &newtmp, DbObj &newauxtmp)
{
CStringList addrlist;
CString	line;

	for (;;)
	{
		if ( line << i )	return (1);
		if (line.GetLength() == 0)	break;

		if (addrlist.GetCount() > MAXDUMPCNT)
		{
			create_list(addrlist, aliasname, newaliases,
				newtmp, newauxtmp);
			addrlist.RemoveAll();
		}
		addrlist.AddTail(line.Mid(1, line.GetLength()-2));
	}

	if (addrlist.GetCount())
		create_list(addrlist, aliasname, newaliases, newtmp, newauxtmp);
	return (0);
}

static int makealiases(istream &is)
{
CString	line;
DbObj newaliases, workaliases, newtmp;
char	*auxtmpfilename=mktmpfilename();
char	*auxtmpfilename2=mktmpfilename();

	if (!auxtmpfilename || !auxtmpfilename2 ||
	    newaliases.Open(tmpfilename, "N") ||
		workaliases.Open(auxtmpfilename, "N") ||
		newtmp.Open(auxtmpfilename2, "N"))
	{
		clog_msg_errno();
		return (1);
	}
	unlink(auxtmpfilename);
	unlink(auxtmpfilename2);
	free(auxtmpfilename);
	free(auxtmpfilename2);

	for (;;)
	{
		if (line << is)	return (1);
		if (line == ".")	break;

		if (*(const char *)line == '*')
		{
			// List of aliases at the beginning of the stream
			line[0]='\n';
			line += '\n';
			if (newtmp.Store(line, line.GetLength(),
				"", 1, "R"))
			{
				clog_msg_errno();
				return (-1);
			}
			continue;
		}

		if (add_aliases(is, line.Mid(1, line.GetLength()-2),
			newaliases, workaliases, newtmp))	return (1);
	}

	if (dumpflag)
	{
	CString	dumpbuf, dumplist, addr, listaddr;
	char	*key, *value;
	size_t	keylen, valuelen;
	AliasRecord new_list(newaliases);
	int	dumpcount=atoi(dumpflag);

		if (dumpcount < 1)
			dumpcount=MAXDUMPCNT;

		for (key=newaliases.FetchFirstKeyVal(keylen, value, valuelen);
			key; free(value),
			key=newaliases.FetchNextKeyVal(keylen, value, valuelen))
		{
			memcpy(addr.GetBuffer(keylen), key, keylen);
			addr.ReleaseBuffer(keylen);
			if (addr.Find('\n') >= 0)
				continue;	// Continuation record,
						// we'll get it as part of the
						// original.

			new_list.Init(addr);

			dumpbuf=addr + ":";
		
		const char *dumpsep=dumpbuf;

			dumplist="";

		int	dumpcnt=0;

			new_list.StartForEach();
			while ((const char *)(listaddr=new_list.NextForEach())
									!= 0)
			{
				if (dumpcnt++ >= dumpcount)
				{
					cout << dumplist << endl << endl;
					dumplist=addr;
					dumpsep=":";
					dumpcnt=1;
				}
				else if (dumplist.GetLength() +
					listaddr.GetLength() > 76)
				{
					cout << dumplist << dumpsep << endl;
					dumplist="        " + listaddr;
					dumpsep=",";
					continue;
				}

				dumplist += dumpsep;
				dumplist += ' ';
				dumplist += listaddr;
				dumpsep=",";
			}
			if (dumplist.GetLength() == 0)
				dumplist += dumpsep;
			cout << dumplist << endl << endl;
		}
	}

	newaliases.Close();
	workaliases.Close();
	newtmp.Close();
	if (!dumpflag && rename(tmpfilename, aliasfilename) < 0)
	{
		clog_msg_prerrno();
		return (1);
	}
	return (0);
}

static void usage()
{
	cerr << "Usage: makealiases -tmp=tmpfile -alias=aliasfile -dump" << endl;
	exit (1);
}

static void cleanup()
{
	unlink(tmpfilename);
}

static RETSIGTYPE sigint_sig(int signum)
{
	cleanup();
	signal(SIGINT, SIG_DFL);
	kill(getpid(), SIGINT);
#if	RETSIGTYPE != void
	return (0);
#endif
}

static RETSIGTYPE sigterm_sig(int signum)
{
	cleanup();
	signal(SIGTERM, SIG_DFL);
	kill(getpid(), SIGTERM);
#if	RETSIGTYPE != void
	return (0);
#endif
}

static RETSIGTYPE sighup_sig(int signum)
{
	cleanup();
	signal(SIGHUP, SIG_DFL);
	kill(getpid(), SIGHUP);
#if	RETSIGTYPE != void
	return (0);
#endif
}

int cppmain(int argc, char **argv)
{
int	argn;

#if HAVE_SETLOCALE
	setlocale(LC_ALL, "C");
#endif

	argn=cargs(argc, argv, arginfo);

	if ((!dumpflag && !aliasfilename) || !tmpfilename)
		usage();

	signal(SIGINT, sigint_sig);
	signal(SIGTERM, sigterm_sig);
	signal(SIGHUP, sighup_sig);
	if (atexit(cleanup)) clog_msg_errno();

	clog_open_stderr("makealiases");

int rc=makealiases(cin);

	cleanup();
	return(rc);
}
