/*
** Copyright 2000-2001 Double Precision, Inc.  See COPYING for
** distribution information.
*/


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<libpq-fe.h>
#include	<time.h>

#include	"authpgsql.h"
#include	"authpgsqlrc.h"
#include	"auth.h"

static const char rcsid[]="$Id: authpgsqllib.c,v 1.1 2001/10/06 19:01:23 mrsam Exp $";

static const char *read_env(const char *env)
{
static char *pgsqlauth=0;
static size_t pgsqlauth_size=0;
size_t	i;
char	*p=0;
int	l=strlen(env);

	if (!pgsqlauth)
	{
	FILE	*f=fopen(AUTHPGSQLRC, "r");
	struct	stat	buf;

		if (!f)	return (0);
		if (fstat(fileno(f), &buf) ||
			(pgsqlauth=malloc(buf.st_size+2)) == 0)
		{
			fclose(f);
			return (0);
		}
		if (fread(pgsqlauth, buf.st_size, 1, f) != 1)
		{
			free(pgsqlauth);
			pgsqlauth=0;
			fclose(f);
			return (0);
		}
		pgsqlauth[pgsqlauth_size=buf.st_size]=0;

		for (i=0; i<pgsqlauth_size; i++)
			if (pgsqlauth[i] == '\n')
				pgsqlauth[i]=0;
		fclose(f);
	}

	for (i=0; i<pgsqlauth_size; )
	{
		p=pgsqlauth+i;
		if (memcmp(p, env, l) == 0 &&
			isspace((int)(unsigned char)p[l]))
		{
			p += l;
			while (*p && *p != '\n' &&
				isspace((int)(unsigned char)*p))
				++p;
			break;
		}

		while (i < pgsqlauth_size)
			if (pgsqlauth[i++] == 0)	break;
	}

	if (i < pgsqlauth_size)
		return (p);
	return (0);
}

static PGresult *pgresult=0;

static PGconn *pgconn=0;

/*
static FILE *DEBUG=0;
*/

static int do_connect()
{
const	char *server;
const	char *userid;
const	char *password;
const	char *database;
const 	char *server_port=0;
const 	char *server_opt=0;
/*
	if (!DEBUG) {
		DEBUG=fopen("/tmp/courier.debug","a");
	}
	fprintf(DEBUG,"Apro il DB!\n");
	fflush(DEBUG);
*/

/*
** Periodically detect dead connections.
*/
	if (pgconn)
	{
		static time_t last_time=0;
		time_t t_check;

		time(&t_check);

		if (t_check < last_time)
			last_time=t_check;	/* System clock changed */

		if (t_check < last_time + 60)
			return (0);

		last_time=t_check;
			
		if (PQstatus(pgconn) == CONNECTION_OK) return (0);

		/*pgsql_close(mysql);*/
		pgconn=0;
	}

	server=read_env("PGSQL_HOST");
	server_port=read_env("PGSQL_PORT");
	userid=read_env("PGSQL_USERNAME");
	password=read_env("PGSQL_PASSWORD");
	database=read_env("PGSQL_DATABASE");
	server_opt=read_env("PGSQL_OPT");

/*
	fprintf(DEBUG,"Letti i parametri!\n");
	fflush(DEBUG);
*/

	if (!userid)
	{
		fprintf(stderr, "authpgsql: PGSQL_USERNAME not set in "
			AUTHPGSQLRC ".\n");
		return (-1);
	}

	if (!database)
	{
		fprintf(stderr, "authpgsql: PGSQL_DATABASE not set in "
			AUTHPGSQLRC ".\n");
		return (-1);
	}

/*
	fprintf(DEBUG,"Connecting to db:%s:%s\%s user=%s pass=%s\n",server,server_port,database,userid,password);
	fflush(DEBUG);
*/
	pgconn = PQsetdbLogin(server, server_port, server_opt, NULL , database,userid,password);

	if (PQstatus(pgconn) == CONNECTION_BAD)
    	{
       		fprintf(stderr, "Connection to database '%s' failed.\n", database);
        	fprintf(stderr, "%s", PQerrorMessage(pgconn));
		pgconn=0;
		return -1;
    	}
/*
	fprintf(DEBUG,"Connected!\n");
	fflush(DEBUG);
*/

	return 0;

}

void auth_pgsql_cleanup()
{
	if (pgconn)
	{
		PQfinish(pgconn);
		pgconn=0;
	}
}

static struct authpgsqluserinfo ui={0, 0, 0, 0, 0, 0, 0};

static void append_username(char *p, const char *username,
			    const char *defdomain)
{
	for (strcpy(p, username); *p; p++)
		if (*p == '"' || *p == '\\' ||
		    (int)(unsigned char)*p < ' ')
			*p=' ';	/* No funny business */
	if (strchr(username, '@') == 0 && defdomain && *defdomain)
		strcat(strcpy(p, "@"), defdomain);
}

struct authpgsqluserinfo *auth_pgsql_getuserinfo(const char *username)
{
const char *user_table;
const char *defdomain;
char	*querybuf, *p;

const char *crypt_field, *clear_field, *maildir_field, *home_field,
	*name_field,
	*login_field, *uid_field, *gid_field, *quota_field, *where_clause;

static const char query[]=
	"SELECT %s, %s, %s, %s, %s, %s, %s, %s, %s FROM %s WHERE %s = '";

	if (do_connect())	return (0);

	if (ui.username)
		free(ui.username);
	if (ui.cryptpw)
		free(ui.cryptpw);
	if (ui.clearpw)
		free(ui.clearpw);
	if (ui.home)
		free(ui.home);
	if (ui.maildir)
		free(ui.maildir);
	if (ui.quota)
		free(ui.quota);
	if (ui.fullname)
		free(ui.fullname);
	memset(&ui, 0, sizeof(ui));

/*
	fprintf(DEBUG,"1Leggo parametri\n");
	fflush(DEBUG);
*/
	user_table=read_env("PGSQL_USER_TABLE");
	defdomain=read_env("DEFAULT_DOMAIN");

	if (!user_table)
	{
		fprintf(stderr, "authpgsql: PGSQL_USER_TABLE not set in "
			AUTHPGSQLRC ".\n");
		return (0);
	}

	crypt_field=read_env("PGSQL_CRYPT_PWFIELD");
	clear_field=read_env("PGSQL_CLEAR_PWFIELD");
	name_field=read_env("PGSQL_NAME_FIELD");
/*
	fprintf(DEBUG,"2Leggo parametri\n");
	fflush(DEBUG);
*/

	if (!crypt_field && !clear_field)
	{
		fprintf(stderr,
			"authpgsql: PGSQL_CRYPT_PWFIELD and "
			"PGSQL_CLEAR_PWFIELD not set in " AUTHPGSQLRC ".\n");
		return (0);
	}
	if (!crypt_field) crypt_field="''";
	if (!clear_field) clear_field="''";
	if (!name_field) name_field="''";

	uid_field = read_env("PGSQL_UID_FIELD");
	if (!uid_field) uid_field = "uid";

	gid_field = read_env("PGSQL_GID_FIELD");
	if (!gid_field) gid_field = "gid";

	login_field = read_env("PGSQL_LOGIN_FIELD");
	if (!login_field) login_field = "id";

	home_field = read_env("PGSQL_HOME_FIELD");
	if (!home_field) home_field = "home";

	maildir_field=read_env("PGSQL_MAILDIR_FIELD");
	if (!maildir_field) maildir_field="''";

	quota_field=read_env("PGSQL_QUOTA_FIELD");
	if (!quota_field) quota_field="''"; 

	where_clause=read_env("PGSQL_WHERE_CLAUSE");
	if (!where_clause) where_clause = "";
	
	if (!defdomain)	defdomain="";

	querybuf=malloc(sizeof(query) + 100 + strlen(user_table) + strlen(defdomain)
		+ strlen(crypt_field) + strlen(clear_field) + strlen(maildir_field)
		+ strlen(uid_field) + strlen(gid_field) + 2 * strlen(login_field)
		+ strlen(home_field) + strlen(quota_field) + strlen(where_clause)
			+ strlen(name_field));
	if (!querybuf)
	{
		perror("malloc");
		return (0);
	}

	sprintf(querybuf, query, login_field, crypt_field, clear_field, 
		uid_field, gid_field, home_field, maildir_field, quota_field,
		name_field, user_table, login_field);
	p=querybuf+strlen(querybuf);

	append_username(p, username, defdomain);
	strcat(p, "'");
	
	if (strcmp(where_clause, "")) {
		strcat(p, " AND (");
		strcat(p, where_clause);
		strcat(p, ")");
	}

/*
	fprintf(DEBUG,"Eseguo la query:\n%s\n",querybuf);
	fflush(DEBUG);
*/
	pgresult = PQexec(pgconn, querybuf);
    	if (!pgresult || PQresultStatus(pgresult) != PGRES_TUPLES_OK)
    	{
/*
	fprintf(DEBUG,"Problema\n");
	fflush(DEBUG);
*/

        	PQclear(pgresult);
	
		/* <o.blasnik@nextra.de> */

		auth_pgsql_cleanup();

		if (do_connect())
		{
			free(querybuf);
			return (0);
		}

		pgresult = PQexec(pgconn, querybuf);
    		if (!pgresult || PQresultStatus(pgresult) != PGRES_TUPLES_OK)
		{
/*
	fprintf(DEBUG,"Problemadoppio\n");
	fflush(DEBUG);
*/
        		PQclear(pgresult);
			free(querybuf);
			auth_pgsql_cleanup();
			/* Server went down, that's OK,
			** try again next time.
			*/
			return (0);
		}
	}
	free(querybuf);
/*
	fprintf(DEBUG,"La query e' ok\n");
	fflush(DEBUG);
*/

		if (PQntuples(pgresult)>0)
		{
/*
	fprintf(DEBUG,"Leggo i risultati\n");
	fflush(DEBUG);
*/
			ui.username=strdup(PQgetvalue(pgresult,0,0));
			ui.cryptpw=strdup(PQgetvalue(pgresult,0,1));
			ui.clearpw=strdup(PQgetvalue(pgresult,0,2));
			ui.uid=atol(PQgetvalue(pgresult,0,3));
			ui.gid=atol(PQgetvalue(pgresult,0,4));
			ui.home=strdup(PQgetvalue(pgresult,0,5));
			ui.maildir=strdup(PQgetvalue(pgresult,0,6));
			ui.quota=strdup(PQgetvalue(pgresult,0,7));
			ui.fullname=strdup(PQgetvalue(pgresult,0,8));
/*
	fprintf(DEBUG,"risultati letti\n");
	fflush(DEBUG);
*/
			if (!ui.username || !ui.cryptpw ||
				!ui.home || !ui.maildir  )
			{
				PQclear(pgresult);
				return (0);
			}
/*
	fprintf(DEBUG,"ci sono tutti\n");
	fflush(DEBUG);
*/

			if (!ui.cryptpw[0])
			{
				free(ui.cryptpw);
				ui.cryptpw=0;
			}

			if (!ui.clearpw[0])
			{
				free(ui.clearpw);
				ui.clearpw=0;
			}
		}
        	PQclear(pgresult);
/*
	fprintf(DEBUG,"Mail dir:%s\n",ui.maildir);
	fflush(DEBUG);
*/
	return (&ui);
}

int auth_pgsql_setpass(const char *user, const char *pass)
{
	char *newpass_crypt;
	const char *newpass_crypt_ptr;
	const char *p;
	int l;
	char *sql_buf;
	const char *comma;
	int rc=0;

	const char *clear_field;
	const char *crypt_field;
	const char *defdomain;
	const char *where_clause;
	const char *user_table;
	const char *login_field;

	if (!pgconn)
		return (-1);


	if (!(newpass_crypt=authcryptpasswd(pass, "{crypt}")))
		return (-1);

	if (!(newpass_crypt_ptr=strchr(newpass_crypt, '}')))
	{
		free(newpass_crypt);	/* WTF???? */
		return (-1);
	}
	++newpass_crypt_ptr;

	for (l=0, p=pass; *p; p++)
	{
		if ((int)(unsigned char)*p < ' ')
		{
			free(newpass_crypt);
			return (-1);
		}
		if (*p == '"' || *p == '\\')
			++l;
		++l;
	}

	login_field = read_env("PGSQL_LOGIN_FIELD");
	if (!login_field) login_field = "id";
	crypt_field=read_env("PGSQL_CRYPT_PWFIELD");
	clear_field=read_env("PGSQL_CLEAR_PWFIELD");
	defdomain=read_env("DEFAULT_DOMAIN");
	where_clause=read_env("PGSQL_WHERE_CLAUSE");
	user_table=read_env("PGSQL_USER_TABLE");

	sql_buf=malloc(strlen(crypt_field ? crypt_field:"")
		       + strlen(clear_field ? clear_field:"")
		       + strlen(defdomain ? defdomain:"")
		       + strlen(login_field) + l + strlen(newpass_crypt)
		       + strlen(user_table)
		       + strlen(where_clause ? where_clause:"")
		       + 200);

	if (!sql_buf)
	{
		free(newpass_crypt);
		return (-1);
	}

	sprintf(sql_buf, "UPDATE %s SET", user_table);

	comma="";

	if (clear_field && *clear_field)
	{
		char *q;

		strcat(strcat(strcat(sql_buf, " "), clear_field),
		       "='");

		q=sql_buf+strlen(sql_buf);
		while (*pass)
		{
			if (*pass == '"' || *pass == '\\')
				*q++= '\\';
			*q++ = *pass++;
		}
		strcpy(q, "'");
		comma=", ";
	}

	if (crypt_field && *crypt_field)
	{
		strcat(strcat(strcat(strcat(strcat(strcat(sql_buf, comma),
						   " "),
					    crypt_field),
				     "='"),
			      newpass_crypt_ptr),
		       "'");
	}
	free(newpass_crypt);

	strcat(strcat(strcat(sql_buf, " WHERE "),
		      login_field),
	       "='");

	append_username(sql_buf+strlen(sql_buf), user, defdomain);

	strcat(sql_buf, "'");

	if (where_clause && *where_clause)
	{
		strcat(sql_buf, " AND (");
		strcat(sql_buf, where_clause);
		strcat(sql_buf, ")");
	}

	pgresult=PQexec (pgconn, sql_buf);
	if (!pgresult || PQresultStatus(pgresult) != PGRES_COMMAND_OK)
	{
		rc= -1;
		auth_pgsql_cleanup();
	}
	PQclear(pgresult);
	free(sql_buf);
	return (rc);
}
