/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File:	pile.h
 * Author: 	Joe English
 * Created: 	10Oct91
 * Description: Mark/release style memory allocator.
 *		A pile works like a stack, with memory allocated
 *		sequentially.  Rather than freeing individually
 *		allocated pieces, the caller may set a 'mark' at
 * 		one point and later free everything allocated after
 * 		the mark with a single call.
 * Credits: 	This module is strongly influenced by
 * 		the GNU libc 'obstack' interface.
 *		This code was originally written for use in
 * 		a proprietary product of Advanced Rotorcraft Technology, Inc.
 *
 * 1999/02/12 02:50:48
 * 1.7
 * 
 */

#ifndef PILE_H
#define PILE_H 1

typedef struct pileRec
{
    char	*block;		/* storage area */
    unsigned	top;		/* high-water mark */
    int 	endptr;		/* end of incremental growth; -1 if !incr.mode*/
    unsigned	inc; 		/* block increment size */
    unsigned	nbig;		/* #big blocks allocated */
    unsigned	maxbig;		/* max space for big blocks */
    char 	**bigblocks;	/* Space for big blocks */
} *pile,pilemark;

/* %%% make pile opaque, new struct for pilemark */

extern pile 		pcreate		(void);
extern pilemark		pmark		(pile);
extern int  		prelease	(pile,pilemark);
extern void		*palloc		(pile,unsigned short);
extern void		pdestroy	(pile);
extern char 		*pstrdup	(pile,const char *);	

/* Incremental allocation: */

extern void 		pstart		(pile);
extern void 		paddch		(pile, char ch);
extern void 		paddstr		(pile, const char *str);
extern void *		pfinish		(pile);

#endif /* PILE_H */

