/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AuthenticationView : NSObject <PrefsViewProtocol>
 *
 *  Description:  This view contains authentication preferences
 *                (PAP, CHAP, etc.)
 */

#import "AppKit/NSView.h"
#import "AppKit/NSPanel.h"
#import "AppKit/NSBox.h"
#import "AppKit/NSPopUpButton.h"
#import "AppKit/NSButton.h"
#import "AppKit/NSTextField.h"
#import "AppKit/NSSecureTextField.h"

#import "Authentication.h"
#import "AppController.h"
#import "AppDefaults.h"
#import "SessionWindow.h"

@implementation AuthenticationView

- (id) initWithPrefs: (NSMutableDictionary *) sessionPrefs
{
  NSView *schemeFrameView;
  NSView *userFrameView;
  NSView *systemFrameView;

  [super init];

  if ((prefs = [sessionPrefs objectForKey: @"Authentication"]) == nil)
  {
    [sessionPrefs 
      setObject: [NSMutableDictionary dictionary] forKey: @"Authentication"];
    prefs = [sessionPrefs objectForKey: @"Authentication"];
  }

  view = [[NSView alloc] initWithFrame: NSMakeRect (10, 44, 280, 393)];

  // Authentication scheme -------------------------------------- 
  schemeFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 343, 280, 47)];
  [schemeFrame setTitle: @"Authentication Scheme"];
  [view addSubview: schemeFrame];
  schemeFrameView = [schemeFrame contentView];

  schemePop = [[NSPopUpButton alloc] initWithFrame:
    NSMakeRect (60, 0, 156, 21)];
  [schemePop setAutoenablesItems: NO];
  [schemePop addItemWithTitle: @"PAP/CHAP"];
  [schemePop addItemWithTitle: @"Chat script"];
  [schemePop setAction: @selector (schemePopAction)];
  [schemePop setTarget: self];
  [schemeFrameView addSubview: schemePop];
  
  // User information ------------------------------------------- 
  userFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 239, 280, 99)];
  [userFrame setTitle: @"User Information"];
  [view addSubview: userFrame];
  userFrameView = [userFrame contentView];

  // User name
  userNameLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 52, 101, 21)];
  [userNameLabel setAlignment: NSRightTextAlignment];
  [userNameLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [userNameLabel setSelectable: NO];
  [userNameLabel setEditable: NO];
  [userNameLabel setBezeled: NO];
  [userNameLabel setBordered: NO];
  [userNameLabel setStringValue: @"User name"];
  [userFrameView addSubview: userNameLabel];

  userNameTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (106, 52, 125, 21)];
  [userFrameView addSubview: userNameTF];

  // Password
  passwordLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 101, 21)];
  [passwordLabel setAlignment: NSRightTextAlignment];
  [passwordLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [passwordLabel setSelectable: NO];
  [passwordLabel setEditable: NO];
  [passwordLabel setBezeled: NO];
  [passwordLabel setBordered: NO];
  [passwordLabel setStringValue: @"Password"];
  [userFrameView addSubview: passwordLabel];

  passwordTF = [[NSSecureTextField alloc] initWithFrame: 
    NSMakeRect (106, 26, 125, 21)];
  [userFrameView addSubview: passwordTF];

  // Linking TF
  [userNameTF setNextText: passwordTF];
  [passwordTF setNextText: userNameTF];

  // Remember
  rememberButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (106, 0, 83, 21)];
  [rememberButton setTitle: @"Remember"];
  [rememberButton setButtonType: NSSwitchButton];
  [rememberButton setAlignment: NSCenterTextAlignment];
  [userFrameView addSubview: rememberButton];
  
  // System information ----------------------------------------- 
  systemFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 135, 280, 99)];
  [systemFrame setTitle: @"System Information"];
  [view addSubview: systemFrame];
  systemFrameView = [systemFrame contentView];
 
  // Remote system name
  remoteLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 52, 126, 21)];
  [remoteLabel setAlignment: NSRightTextAlignment];
  [remoteLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [remoteLabel setSelectable: NO];
  [remoteLabel setEditable: NO];
  [remoteLabel setBezeled: NO];
  [remoteLabel setBordered: NO];
  [remoteLabel setStringValue: @"Remote system name"];
  [systemFrameView addSubview: remoteLabel];

  remoteTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (131, 52, 125, 21)];
  [systemFrameView addSubview: remoteTF];

  // Local system name
  localLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 126, 21)];
  [localLabel setAlignment: NSRightTextAlignment];
  [localLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [localLabel setSelectable: NO];
  [localLabel setEditable: NO];
  [localLabel setBezeled: NO];
  [localLabel setBordered: NO];
  [localLabel setStringValue: @"Local system name"];
  [systemFrameView addSubview: localLabel];

  localTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (131, 26, 125, 21)];
  [systemFrameView addSubview: localTF];

  // Append domain name
  domainLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 0, 126, 21)];
  [domainLabel setAlignment: NSRightTextAlignment];
  [domainLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [domainLabel setSelectable: NO];
  [domainLabel setEditable: NO];
  [domainLabel setBezeled: NO];
  [domainLabel setBordered: NO];
  [domainLabel setStringValue: @"Append domain name"];
  [systemFrameView addSubview: domainLabel];

  domainTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (131, 0, 125, 21)];
  [systemFrameView addSubview: domainTF];

  [remoteTF setNextText: localTF];
  [localTF setNextText: domainTF];
  [domainTF setNextText: remoteTF];
  
  // Advanced button
  advancedButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (198, 106, 82, 24)];
  [advancedButton setButtonType: NSMomentaryPushButton];
  [advancedButton setTitle: @"Advanced..."];
  [advancedButton setAction: @selector (advancedButtonAction)];
  [advancedButton setTarget: self];
  [view addSubview: advancedButton];

  RELEASE (schemePop);
  RELEASE (schemeFrame);

  RELEASE (userNameLabel);
  RELEASE (userNameTF);
  RELEASE (passwordLabel);
  RELEASE (passwordTF);
  RELEASE (rememberButton);
  RELEASE (userFrame);
  
  RELEASE (remoteLabel);
  RELEASE (remoteTF);
  RELEASE (localLabel);
  RELEASE (localTF);
  RELEASE (domainLabel);
  RELEASE (domainTF);
  RELEASE (systemFrame);

  RELEASE (advancedButton);

  // load settings or set defaults
  [self setDefaults];

  return self;
}

// dealloc never called for array memebers
- (void) release
{
  NSLog (@"AuthenticationView: release (%i)", [view retainCount]);
  if ([view superview])
  {
    [view removeFromSuperview];
  }
  else
  {
    RELEASE (view);
  }

  [super release];
}

/*-------------------------------------------------------------------------*
 *  Protocol methods
 *-------------------------------------------------------------------------*/
- (id) show: (id)superView
{
  [superView addSubview: view];
  RELEASE (view);

  return userNameTF;
}

- (void) hide 
{
  RETAIN (view);
  [view removeFromSuperview];
}

- (void) setDefaults
{
  NSString *secretsString;
  NSArray  *secretsArray;

  if ([prefs count] > 0)
  {
    [schemePop selectItemWithTitle: [prefs objectForKey: @"Scheme"]];
    [userNameTF setStringValue: [prefs objectForKey: @"UserName"]];


    secretsString = [[ConnectApp appDefaults]
      sessionBundle: [[ConnectApp sessionWindow] getSelectedSessionName]
      fileContents: @"secret.pap"];
    secretsArray = [secretsString componentsSeparatedByString: @"\t"];
    [passwordTF setStringValue: [secretsArray objectAtIndex: 2]];

    RELEASE (secretsString);

    if ([[prefs objectForKey: @"Remember"] isEqualToString: @"YES"])
    {
      [rememberButton setState: NSOnState];
    }
    else
    {
      [rememberButton setState: NSOffState];
    }

    [remoteTF setStringValue: [prefs objectForKey: @"RemoteSystemName"]];
    [localTF setStringValue: [prefs objectForKey: @"LocalSystemName"]];
    [domainTF setStringValue: [prefs objectForKey: @"Domain"]];
  }
}

- (NSMutableDictionary *) prefsDict
{
  NSMutableString *isRemember;
 
  isRemember = [NSMutableString stringWithString: @"YES"];

  [prefs setObject: [schemePop titleOfSelectedItem] forKey: @"Scheme"];
  if ([[userNameTF stringValue] length] == 0)
  {
    NSRunAlertPanel(@"Set", @"You forgot to specify user name in Authentication section.\n Preferences was not set.", @"Ok", nil, nil);
    return nil;
  }

  [prefs setObject: [userNameTF stringValue] forKey: @"UserName"];
  [prefs setObject: [passwordTF stringValue] forKey: @"Password"];

  if ([rememberButton state] == NSOffState) [isRemember setString: @"NO"];
  [prefs setObject: isRemember forKey: @"Remember"];

  [prefs setObject: [remoteTF stringValue] forKey: @"RemoteSystemName"];
  [prefs setObject: [localTF stringValue] forKey: @"LocalSystemName"];
  [prefs setObject: [domainTF stringValue] forKey: @"Domain"];

  return prefs;
}

/*-------------------------------------------------------------------------*
 *  Controls' action methods
 *-------------------------------------------------------------------------*/

@end
