package org.apache.commons.javaflow.bytecode.transformation.tests;

import org.apache.commons.javaflow.Continuation;
import org.apache.commons.javaflow.bytecode.transformation.AbstractTransformerTestCase;
import org.apache.commons.javaflow.bytecode.transformation.data.SimpleSerializable;

public abstract class AbstractResumeTestCase extends AbstractTransformerTestCase {

    public void testSimpleSuspendResume() throws Exception {
        final SimpleSerializable r = new SimpleSerializable();
        assertTrue(r.g == -1);
        assertTrue(r.l == -1);
        Continuation c1 = Continuation.startWith(r);
        assertTrue(r.g == 0);
        assertTrue(r.l == 0);
        Continuation c2 = Continuation.continueWith(c1);
        assertTrue(r.g == 1);
        assertTrue(r.l == 1);
        Continuation c3 = Continuation.continueWith(c2);
        assertTrue(r.g == 2);
        assertTrue(r.l == 2);
    }


    public void testContinuationBranching() throws Exception {
        final SimpleSerializable r = new SimpleSerializable();
        assertTrue(r.g == -1);
        assertTrue(r.l == -1);
        Continuation c1 = Continuation.startWith(r);
        assertTrue(r.g == 0);
        assertTrue(r.l == 0);
        Continuation c2 = Continuation.continueWith(c1);
        assertTrue(r.g == 1);
        assertTrue(r.l == 1);
        Continuation c31 = Continuation.continueWith(c2);
        assertTrue(r.g == 2);
        assertTrue(r.l == 2);
        Continuation c32 = Continuation.continueWith(c2);
        assertTrue(r.g == 3);
        assertTrue(r.l == 2);
    }
}
