#!/usr/bin/python
# -*- coding: Latin-1 -*-
entete = """
###############################################################################
#
#    This file is part of COLLATINVS.
#
#    COLLATINVS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    COLLATINVS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with COLLATINVS; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###############################################################################
"""
# Le module collatcom a pour but :
# 1. d'aller dcharger dans un dpt local, en les renommant de manire 
#    significative, les lexiques personnels que les utilisateurs-
#    contributeurs  ont accept d'envoyer sur le dpt distant. Le protocole
#    d'envoi est smtp, et le protocol de dchargement pop3. Un
#    compte pop3 doit tre crer pour cet usage exclusif ;
#
# 2. Pour chaque item de chaque contribution, soumettre au modrateur 
#    les diffrences entre le lexique officiel et le lexique de la
#    contribution. Le modrateur pourra accepter ou refuser la
#    proposition de l'item.
# 
# 3. D'aller placer sur un dpt html ou ftp le lexique officiel ainsi
#    modifi. 

# BOGUES
# Une entre rejete s'ajoute quand mme au lexique.

from collat import *
import sys, os, time, string, re
# ajouter un chemin d'importation
sys.path.append(viaD)
import conf
import confM
from xml.dom import minidom

#############################################################################
#                         RECUPERATION DES CONTRIBUTIONS                    #
#############################################################################

def nomenNouum():
    """ Sonde les contributions enregistres pour donner un nouveau nom"""
    # date
    dies = time.strftime("%d%m%y", time.localtime(time.time()))
    heure=time.strftime("%H%M%S")  
    return viaD+dies+'-'+heure+".xml"

def recup():
    import poplib
    M = poplib.POP3(confM.pop)
    M.user(confM.user)
    M.pass_(confM.passe)
    numMessages = len(M.list()[1])
    print numMessages, "contributions reues"
    for i in range(numMessages):
            f = open(nomenNouum(), 'w')
            for j in M.retr(i+1)[1]:
                f.write("%s\n" % j)
            f.close
            # penser  supprimer le fichier sur le serveur aprs finalisation
            # M.dele(i+1)
    M.quit()

#############################################################################
#                                MODERATION                                 #
#############################################################################
def examine(fc):
    f = open(viaD+fc)
    s = f.read()
    f.close()
    debut = s.find('<?xml')
    # examen et affichage de l'en-tte
    # h = s[:debut]
    # etc.
    # extraction de la chane xml
    s = s[debut:]
    # parsage DOM de la contrib
    doc = minidom.parseString(s)
    canonsP = doc.getElementsByTagName('canon')
    # constitution du lexique personnel lexicumN
    for i in canonsP:
        gr = i.childNodes[3].firstChild.data 
        lexicumN[gr] = lisEntreeP(i)
    retour = False
    for e in lexicumN.keys():
    # examen de chaque entre:
        # affichage
        lexicumN[e].affiche()
        if lexicumN[e].status > 1 and lexique.has_key(lexicumN[e].graphie):
            # destruction ?
            r = raw_input("--- Delere ? (Nolo, volo) [Nv]  ---  ")
            if "Vv".find(r) > -1:
                del(lexique[lexicumN[e].graphie])
                print "Vocem %s deleui." % lexicumN[e].graphie
                retour = True
            else: print "Vocem %s non deleui." % lexicumN[e].graphie
        elif lexicumN[e].status == 0 or not lexique.has_key(lexicumN[e].graphie): 
            r = raw_input("+++ Addere ? (nolo, Volo) [nV] +++  ")
            if "Vv".find(r) > -1:
                lexique[lexicumN[e].graphie] = lexicumN[e].entree()
                print "Vocem %s addidi." % lexicumN[e].graphie
                retour = True
            else: print "Vocem %s non addidi." % lexicumN[e].graphie
        else:
            # recherche de l'entre dans lexique : dition
            print "-----------------------------------------"
            print "       lexicum habet :"
            print "-----------------------------------------"
            lexique[lexicumN[e].graphie].affiche()
            r = raw_input("~~~ Corrigere ? (nolo, Volo) [nV]  ~~~  ")
            if "Vv".find(r) > -1:
                lexique[lexicumN[e].graphie] = lexicumN[e].entree()
                retour = True
                print "Vocem %s correxi." % lexicumN[e].graphie
            else: print "Vocem %s non correxi." % lexicumN[e].graphie
    return retour
# def examine (fin)

expr = re.compile("^[\d]{6,6}.[\d]{6,6}.xml$")
lexicumN = tlexicumP()
def modere():
    listef = os.listdir(viaD)
    for fcontrib in listef:
        # tri des fichiers selon le nom
        if expr.match(fcontrib) != None:
            print "Examen de la contribution ", fcontrib
            # clatement des fichiers volumineux par tranches de 10 entres ?
            if examine(fcontrib):
               l_scribe()
               precompile()
            else: print "cum nihil mutatum est, nihil facio"
            # dplacement de la contrib dans les archives

if __name__ == "__main__":
    recup()
    modere()
