//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2014 The CodeLite Team
// file name            : memoryviewbase.cpp
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// This file was auto-generated by codelite's wxCrafter Plugin
// wxCrafter project file: memoryviewbase.wxcp
// Do not modify this file by hand!
//////////////////////////////////////////////////////////////////////

#include "memoryviewbase.h"


// Declare the bitmap loading function
extern void wxC5C75InitBitmapResources();

static bool bBitmapLoaded = false;


MemoryViewBase::MemoryViewBase(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style)
    : wxPanel(parent, id, pos, size, style)
{
    if ( !bBitmapLoaded ) {
        // We need to initialise the default bitmap handler
        wxXmlResource::Get()->AddHandler(new wxBitmapXmlHandler);
        wxC5C75InitBitmapResources();
        bBitmapLoaded = true;
    }
    
    bSizer1 = new wxBoxSizer(wxVERTICAL);
    this->SetSizer(bSizer1);
    
    flexGridSizer6 = new wxFlexGridSizer(  0, 6, 0, 0);
    flexGridSizer6->SetFlexibleDirection( wxBOTH );
    flexGridSizer6->SetNonFlexibleGrowMode( wxFLEX_GROWMODE_SPECIFIED );
    flexGridSizer6->AddGrowableCol(1);
    
    bSizer1->Add(flexGridSizer6, 0, wxALL|wxEXPAND, 5);
    
    m_staticText2 = new wxStaticText(this, wxID_ANY, _("Address:"), wxDefaultPosition, wxSize(-1, -1), 0);
    
    flexGridSizer6->Add(m_staticText2, 0, wxLEFT|wxTOP|wxBOTTOM|wxALIGN_CENTER_VERTICAL, 5);
    
    m_textCtrlExpression = new wxTextCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxSize(-1, -1), wxTE_PROCESS_ENTER);
    m_textCtrlExpression->SetToolTip(_("Address or pointer to watch"));
    
    flexGridSizer6->Add(m_textCtrlExpression, 1, wxALL|wxEXPAND, 5);
    
    m_staticText1 = new wxStaticText(this, wxID_ANY, _("Size:"), wxDefaultPosition, wxSize(-1, -1), 0);
    m_staticText1->SetToolTip(_("Memory size to view"));
    
    flexGridSizer6->Add(m_staticText1, 0, wxLEFT|wxTOP|wxBOTTOM|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
    
    wxArrayString m_choiceSizeArr;
    m_choiceSizeArr.Add(wxT("32"));
    m_choiceSizeArr.Add(wxT("64"));
    m_choiceSizeArr.Add(wxT("128"));
    m_choiceSizeArr.Add(wxT("256"));
    m_choiceSizeArr.Add(wxT("512"));
    m_choiceSizeArr.Add(wxT("1024"));
    m_choiceSizeArr.Add(wxT("2048"));
    m_choiceSizeArr.Add(wxT("4096"));
    m_choiceSize = new wxChoice(this, wxID_ANY, wxDefaultPosition, wxSize(-1,-1), m_choiceSizeArr, 0);
    m_choiceSize->SetToolTip(_("Memory size to view"));
    m_choiceSize->SetSelection(0);
    
    flexGridSizer6->Add(m_choiceSize, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 5);
    
    m_staticText8 = new wxStaticText(this, wxID_ANY, _("Number of columns:"), wxDefaultPosition, wxSize(-1,-1), 0);
    
    flexGridSizer6->Add(m_staticText8, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
    
    wxArrayString m_choiceColsArr;
    m_choiceColsArr.Add(wxT("4"));
    m_choiceColsArr.Add(wxT("8"));
    m_choiceColsArr.Add(wxT("16"));
    m_choiceColsArr.Add(wxT("32"));
    m_choiceCols = new wxChoice(this, wxID_ANY, wxDefaultPosition, wxSize(-1,-1), m_choiceColsArr, 0);
    m_choiceCols->SetToolTip(_("Number of columns to use per row"));
    m_choiceCols->SetSelection(2);
    
    flexGridSizer6->Add(m_choiceCols, 0, wxALL, 5);
    
    bSizer3 = new wxBoxSizer(wxHORIZONTAL);
    
    bSizer1->Add(bSizer3, 1, wxEXPAND, 5);
    
    m_textCtrlMemory = new wxTextCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxSize(-1, -1), wxTE_RICH2|wxTE_MULTILINE|wxTE_DONTWRAP);
    #ifdef __WXMSW__
    // To get the newer version of the font on MSW, we use font wxSYS_DEFAULT_GUI_FONT with family set to wxFONTFAMILY_TELETYPE
    wxFont m_textCtrlMemoryFont = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
    m_textCtrlMemoryFont.SetFamily(wxFONTFAMILY_TELETYPE);
    #else
    wxFont m_textCtrlMemoryFont = wxSystemSettings::GetFont(wxSYS_ANSI_FIXED_FONT);
    m_textCtrlMemoryFont.SetFamily(wxFONTFAMILY_TELETYPE);
    #endif
    m_textCtrlMemory->SetFont(m_textCtrlMemoryFont);
    
    bSizer3->Add(m_textCtrlMemory, 1, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5);
    
    bSizer4 = new wxBoxSizer(wxVERTICAL);
    
    bSizer3->Add(bSizer4, 0, 0, 5);
    
    m_buttonEvaluate = new wxButton(this, wxID_ANY, _("Evaluate"), wxDefaultPosition, wxSize(-1, -1), 0);
    m_buttonEvaluate->SetDefault();
    m_buttonEvaluate->SetToolTip(_("Evaluate the expression in the \"Address\" field"));
    
    bSizer4->Add(m_buttonEvaluate, 0, wxALL|wxEXPAND, 5);
    
    m_buttonUpdate = new wxButton(this, wxID_ANY, _("Update"), wxDefaultPosition, wxSize(-1, -1), 0);
    m_buttonUpdate->SetToolTip(_("Update the memory in the main display area to apply your changes"));
    
    bSizer4->Add(m_buttonUpdate, 0, wxALL|wxEXPAND, 5);
    
    SetSizeHints(596,300);
    if ( GetSizer() ) {
         GetSizer()->Fit(this);
    }
    Centre(wxBOTH);
    // Connect events
    m_textCtrlExpression->Connect(wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(MemoryViewBase::OnTextEntered), NULL, this);
    m_choiceSize->Connect(wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler(MemoryViewBase::OnMemorySize), NULL, this);
    m_choiceCols->Connect(wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler(MemoryViewBase::OnNumberOfRows), NULL, this);
    m_textCtrlMemory->Connect(wxEVT_LEFT_DCLICK, wxMouseEventHandler(MemoryViewBase::OnTextDClick), NULL, this);
    m_buttonEvaluate->Connect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MemoryViewBase::OnEvaluate), NULL, this);
    m_buttonEvaluate->Connect(wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MemoryViewBase::OnEvaluateUI), NULL, this);
    m_buttonUpdate->Connect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MemoryViewBase::OnUpdate), NULL, this);
    
}

MemoryViewBase::~MemoryViewBase()
{
    m_textCtrlExpression->Disconnect(wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(MemoryViewBase::OnTextEntered), NULL, this);
    m_choiceSize->Disconnect(wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler(MemoryViewBase::OnMemorySize), NULL, this);
    m_choiceCols->Disconnect(wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler(MemoryViewBase::OnNumberOfRows), NULL, this);
    m_textCtrlMemory->Disconnect(wxEVT_LEFT_DCLICK, wxMouseEventHandler(MemoryViewBase::OnTextDClick), NULL, this);
    m_buttonEvaluate->Disconnect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MemoryViewBase::OnEvaluate), NULL, this);
    m_buttonEvaluate->Disconnect(wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MemoryViewBase::OnEvaluateUI), NULL, this);
    m_buttonUpdate->Disconnect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MemoryViewBase::OnUpdate), NULL, this);
    
}
