namespace Clinica {

    public class PluginEngine : Peas.Engine {
    
		private ResourceManager resource_manager;
        
        public PluginEngine (ResourceManager resources) {
            GLib.Object ();
            resource_manager = resources;
            
            /* If plugins are globally disabled do not use them */
            if (!resource_manager.settings.get_boolean ("use-plugins"))
                return;
         
            /* Add a search path useful to us */   
            debug ("Scanning %s for plugins", resource_manager.get_plugins_dir ());
            add_search_path (resource_manager.get_plugins_dir (), null);
            
            /* Connect callback to make loading and unloading persistent */
            load_plugin.connect (on_load_plugin);
            unload_plugin.connect (on_unload_plugin);
        }
        
        private void on_load_plugin (Peas.PluginInfo info) {
            resource_manager.settings.activate_plugin (info.get_module_name ());
        }
        
        private void on_unload_plugin (Peas.PluginInfo info) {
            resource_manager.settings.deactivate_plugin (info.get_module_name ());
        }
    }

}
