# test the calculator in OIC mode

use IPC::Open2 qw(open2);

my @tests = (
    ['0-1-1m00', 'm00', '-1', '(0 - -1) / -1'],
    ['-7.5.5-2m01', 'm01', '4', '(-7.5 - .5) / -2'],
    ['m1m0.5m2', 'm02', '10', '(m01 - m00) / .5'],
    ['m2m1m1m3', 'm03', '1.5', '(m02 - m01) / m01'],
    # XXX more tests are necessary
);

my $maxtest = @tests;
print "1..$maxtest\n";

my @l = map { "-I$_" } @INC;
my $pid = open2(\*WRITE, \*READ, $^X, @l, 'bin/intercalc', '--batch', '-moic');

select READ; $| = 1; select STDOUT;

my $testnum = 1;
for my $test (@tests) {
    my ($cmd, $mem, $res, $calc) = @$test;
    print READ "$cmd\n";
    my $line = <WRITE>;
    chomp $line;
    my ($gm, $gr, $gc) = split(/\s+/, $line, 3);
    my $not = 'not ';
    if ($gm ne $mem) {
	print STDERR "FAIL $testnum mem ($gm ne $mem)\n";
    } elsif ($gr ne $res) {
	print STDERR "FAIL $testnum res ($gr ne $res)\n";
    } elsif ($gc ne $calc) {
	print STDERR "FAIL $testnum res ($gc ne $calc)\n";
    } else {
	$not = '';
    }
    print "${not}ok ", $testnum++, "\n";
}

