
#include "Core/precomp.h"
#include <windows.h>
#include "Core/System/Win32/init_win32.h"
#include "API/GL/setupgl.h"
#include "displaycard_opengl_win32.h"
#include "API/Core/System/cl_assert.h"

class CL_OpenGL_Initializer : public CL_Win32EventListener
{
public:
	CL_OpenGL_Initializer();
	~CL_OpenGL_Initializer();
	virtual bool received_event(UINT uMsg, WPARAM wParam, LPARAM lParam);
};

// ------------------------------------------------------------------------

CL_OpenGL_Initializer *opengl_initializer = NULL;

void CL_SetupGL::init()
{
	opengl_initializer = new CL_OpenGL_Initializer;
}

void CL_SetupGL::deinit()
{
	delete opengl_initializer;
	opengl_initializer = NULL;
}

// ------------------------------------------------------------------------

extern bool global_uses_opengl;
extern void (*opengl_init_function)();

CL_OpenGL_Initializer::CL_OpenGL_Initializer()
{
	global_uses_opengl = true;
	CL_System_Win32::add_listener(this);
	opengl_init_function = CL_DisplayCard_OpenGL_Win32::add_display;
}

CL_OpenGL_Initializer::~CL_OpenGL_Initializer()
{
	CL_System_Win32::remove_listener(this);
}

bool CL_OpenGL_Initializer::received_event(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_DESTROY:
		wglMakeCurrent(NULL, NULL);
		wglDeleteContext(CL_DisplayCard_OpenGL_Win32::context);
		return true;
	
	}
	return false;
}
