/*
	$Id: provider_convpoly.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Convex polygon surfaceprovider class

*/

#include "Core/precomp.h"
#include "API/Core/SurfaceProviders/provider_convpoly.h"
#include "API/Core/System/system.h"

CL_ConvexPolygon::CL_ConvexPolygon(CL_SurfaceProvider *_src, bool _delete_provider) : CL_ConvexPolygon_Basics()
{
	src = _src;
	delete_provider = _delete_provider;
	surface_data = NULL;
	trans_col = -1;
	src_xd = NULL;
	src_yd = NULL;
}

CL_ConvexPolygon::~CL_ConvexPolygon()
{
	delete[] ((char*) surface_data);
	delete[] src_xd;
	delete[] src_yd;
}

long tbl[2048];
int total = 0;
int cnt = 0;

void CL_ConvexPolygon::perform_lock()
{
	bool has_changed = changed;
	CL_ConvexPolygon_Basics::lock();
	src->lock();

	if (src->uses_src_colorkey()) trans_col = src->get_src_colorkey();
	else trans_col = 0;
	
	surface_data = new unsigned char[get_width()*get_height()];
// surface_data = (unsigned char *) CL_Display::get_current_card()->lock();

	src_data = (unsigned char *) src->get_data();
	src_pitch = src->get_width();
	tbl[0] = 0;
	for(int i=1;i<2048;i++) tbl[i] = tbl[i-1]+src_pitch;

	ysurf_pos = 0;
	xsurf_pos = 0;
	pitch = get_width();
	width = max_x - min_x + 1;
	height = max_y - min_y + 1;

	map_y_left = &scanline_left_mapping[height];
	map_y_right = &scanline_right_mapping[height];

	int time = CL_System::get_time(); 

	if (has_changed) create_mapping_deltas();

	lock_8();

	total += CL_System::get_time() - time;
	cnt++;
//	cout << "Time taken for lock8: " << float(total)/cnt << endl;

//	surface_data = NULL;

//	CL_Display::get_current_card()->unlock();
}

void CL_ConvexPolygon::perform_unlock()
{
	delete[] ((char*) surface_data);
	surface_data = NULL;
}

void CL_ConvexPolygon::create_mapping_deltas()
{
	delete[] src_xd;
	delete[] src_yd;
	src_xd = new long[height];
	src_yd = new long[height];
	for (int y=0;y<height;y++)
	{
		if (scanline_left[y] > scanline_right[y])
		{
			int byt = scanline_left[y];
			scanline_left[y] = scanline_right[y];
			scanline_right[y] = byt;

			byt = scanline_left_mapping[y];
			scanline_left_mapping[y] = scanline_right_mapping[y];
			scanline_right_mapping[y] = byt;

			byt = map_y_left[y];
			map_y_left[y] = map_y_right[y];
			map_y_right[y] = byt;
		}

		long dxlen = scanline_right[y]-scanline_left[y]+1;

		src_xd[y] = ((scanline_right_mapping[y]-scanline_left_mapping[y])<<10) / dxlen;
		src_yd[y] = ((map_y_right[y]-map_y_left[y])<<10) / dxlen;
	}
}


void CL_ConvexPolygon::lock_8()
{
	unsigned char *surf_ptr = (unsigned char *) surface_data;
//	unsigned char *src = src_data;

	for (int y=0;y<height;y++)
	{
		long dxlen = scanline_right[y]-scanline_left[y]+1;

		long x = scanline_left[y];
	//	memset(surf_ptr, trans_col, x);
		surf_ptr += x;

		long src_xcount = scanline_left_mapping[y]<<10;
		long src_ycount = map_y_left[y]<<10;

		long srcxd = src_xd[y];
		long srcyd = src_yd[y];

		x += dxlen;
/* 

		FYI: The assembler code below does this:

		do
		{
			*(surf_ptr++) = *(src_data + (src_xcount>>10) + tbl[(src_ycount>>10)]);
			src_xcount += src_xd;
			src_ycount += src_yd;
		} while (--dxlen>0);
*/
/*		#ifdef WIN32
		_asm
		{
			mov edi, surf_ptr
			mov eax, srcxd
			mov ebx, srcyd
			mov ecx, dxlen

			mov edx, src_xcount
drawpixel:
			cmp ecx, 0
			je finished

			mov esi, src

			push edx
			shr edx, 10
			add esi, edx

			mov edx, src_ycount
			shr edx, 10
			shl edx, 2
			add esi, long ptr tbl[edx]

			pop edx

			movsb
		
			add edx, eax
			add src_ycount, ebx

			dec ecx
			jmp drawpixel

finished:
		}

		surf_ptr += dxlen;
	#else
*/
			do
		{
			*(surf_ptr++) = *(src_data + (src_xcount>>10) + tbl[(src_ycount>>10)]);
			src_xcount += srcxd;
			src_ycount += srcyd;
		} while (--dxlen>0);
//	#endif

//		memset(surf_ptr, trans_col, width-x);
		surf_ptr += width-x;
	}
}
