/*
	$Id: netobject.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include <API/Core/IOData/inputsource.h>
#include <API/Core/IOData/outputsource.h>
#include <API/Core/NetObjects/netobject.h>

/*****************************************************************************/

/*CL_NetFileObject::CL_NetFileObject()
{
	input_file=NULL;
	output_file=NULL;
}

bool CL_NetFileObject::open()
{
	CL_InputSourceProvider *file_provider = CL_InputSourceProvider::create_file_provider("");
	input_file=file_provider->open_source(filename);

	return (input_file!=NULL);
}

int CL_NetFileObject::get_size()
{
	if(input_file==NULL) {
		cout << "Opening file " << filename << endl;
		CL_InputSourceProvider *file_provider = CL_InputSourceProvider::create_file_provider("");
		input_file=file_provider->open_source(filename);
	}

	return input_file->size();
}

void CL_NetFileObject::serialize_save(CL_OutputSource *output, int pos, int length)
{
	if(pos==0 && length!=0) {
		output->write_string(filename);
		length-=strlen(filename)+1;
	}
	if(length!=0) {
		if(pos)
			pos-=strlen(filename)+1;
			
		void *data=new char[length];

		input_file->seek(pos, CL_InputSource::seek_set);
		input_file->read(data, length);

		output->write(data, length);

		delete data;
	}
}

void CL_NetFileObject::serialize_load(CL_InputSource *input, int pos, int length)
{
	if(pos==0 && length!=0) {
		cl_assert(output_file==NULL);
		output_file=1;
		
//		char *filename;
//		CL_OutputSourceProvider *file_provider = CL_OutputSourceProvider::create_file_provider("");
//		output_file=file_provider->open_source(filename);
	}
	if(length!=0) {
//		cout << "retrieving file" << endl;
	}
	else	
		cout << "File retrieved" << endl;
}
*/
/*****************************************************************************/
/*
CL_NetObject_Simple::CL_NetObject_Simple()
{
}

CL_NetObject_Simple::~CL_NetObject_Simple()
{
	for(
		std::list<CL_NetData *>::iterator i=serialize_data.begin();
		i != serialize_data.end();
		i++)
	{
		delete *i;
		i=serialize_data.erase(i);
	}
//	CL_Iterator<CL_NetData> it_data(serialize_data);
//	while (it_data.next() != NULL) delete it_data();
}

void CL_NetObject_Simple::serialize_save(CL_OutputSource *output)
{
	for(
		std::list<CL_NetData *>::iterator i=serialize_data.begin();
		i != serialize_data.end();
		i++)
	{
		(*i)->save(output);
	}

//	CL_Iterator<CL_NetData> it_data(serialize_data);
//	while (it_data.next() != NULL) it_data()->save(output);
}

void CL_NetObject_Simple::serialize_load(CL_InputSource *input)
{
	for(
		std::list<CL_NetData *>::iterator i=serialize_data.begin();
		i != serialize_data.end();
		i++)
	{
		(*i)->load(input);
	}

//	CL_Iterator<CL_NetData> it_data(serialize_data);
//	while (it_data.next() != NULL) it_data()->load(input);
}

void CL_NetObject_Simple::add_int32(int *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Int32(ptr, num));
//	serialize_data.add(new CL_NetData_Int32(ptr, num));
}

void CL_NetObject_Simple::add_uint32(unsigned int *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Int32((int *) ptr, num));
//	serialize_data.add(new CL_NetData_Int32((int *) ptr, num));
}

void CL_NetObject_Simple::add_short16(short *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Short16(ptr, num));
//	serialize_data.add(new CL_NetData_Short16(ptr, num));
}

void CL_NetObject_Simple::add_ushort16(unsigned short *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Short16((short *) ptr, num));
//	serialize_data.add(new CL_NetData_Short16((short *) ptr, num));
}

void CL_NetObject_Simple::add_float32(float *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Float32(ptr, num));
//	serialize_data.add(new CL_NetData_Float32(ptr, num));
}

void CL_NetObject_Simple::add_bool(bool *ptr, int num)
{
	serialize_data.push_back(new CL_NetData_Bool(ptr, num));
//	serialize_data.add(new CL_NetData_Bool(ptr, num));
}

void CL_NetObject_Simple::add_data(void *ptr, int size, int num)
{
	serialize_data.push_back(new CL_NetData_Data(ptr, size, num));
//	serialize_data.add(new CL_NetData_Data(ptr, size, num));
}

void CL_NetObject_Simple::add_child(CL_NetObject *child, int num)
{
	serialize_data.push_back(new CL_NetData_Child(child, num));
//	serialize_data.add(new CL_NetData_Child(child, num));
}

void CL_NetObject_Simple::add_netdata(CL_NetData *netdata_child)
{
	serialize_data.push_back(netdata_child);
//	serialize_data.add(netdata_child);
}
*/
// -------------------------------------------------------------------------
//  CL_NetData objects
/*
CL_NetData::CL_NetData(int num)
{
	m_num = num;
}

// --

CL_NetData_Int32::CL_NetData_Int32(int *ptr, int num)
: CL_NetData(num)
{
	m_ptr = ptr;
}

void CL_NetData_Int32::save(CL_OutputSource *output)
{
	for (int i=0; i<m_num; i++) output->write_int32(m_ptr[i]);
}

void CL_NetData_Int32::load(CL_InputSource *input)
{
	for (int i=0; i<m_num; i++) m_ptr[i] = input->read_int32();
}

// --

CL_NetData_Bool::CL_NetData_Bool(bool *ptr, int num)
: CL_NetData(num)
{
	m_ptr = ptr;
}

void CL_NetData_Bool::save(CL_OutputSource *output)
{
	for (int i=0; i<m_num; i++) output->write_uchar8(m_ptr[i]);
}

void CL_NetData_Bool::load(CL_InputSource *input)
{
	for (int i=0; i<m_num; i++) m_ptr[i] = input->read_uchar8() ? true : false;
}

// --

CL_NetData_Short16::CL_NetData_Short16(short *ptr, int num)
: CL_NetData(num)
{
	m_ptr = ptr;
}

void CL_NetData_Short16::save(CL_OutputSource *output)
{
	for (int i=0; i<m_num; i++) output->write_short16(m_ptr[i]);
}

void CL_NetData_Short16::load(CL_InputSource *input)
{
	for (int i=0; i<m_num; i++) m_ptr[i] = input->read_short16();
}

// --

CL_NetData_Float32::CL_NetData_Float32(float *ptr, int num)
: CL_NetData(num)
{
	m_ptr = ptr;
}

void CL_NetData_Float32::save(CL_OutputSource *output)
{
	for (int i=0; i<m_num; i++) output->write_float32(m_ptr[i]);
}

void CL_NetData_Float32::load(CL_InputSource *input)
{
	for (int i=0; i<m_num; i++) m_ptr[i] = input->read_float32();
}

// --

CL_NetData_Data::CL_NetData_Data(void *data, int size, int num)
: CL_NetData(num)
{
	m_data = data;
	m_size = size;
}

void CL_NetData_Data::save(CL_OutputSource *output)
{
	output->write(m_data, m_size*m_num);
}

void CL_NetData_Data::load(CL_InputSource *input)
{
	input->read(m_data, m_size*m_num);
}

// --

CL_NetData_Child::CL_NetData_Child(CL_NetObject *child, int num)
: CL_NetData(num)
{
	m_child = child;
}

void CL_NetData_Child::save(CL_OutputSource *output)
{
	for (int i=0; i<m_num; i++) m_child[i].serialize_save(output);
}

void CL_NetData_Child::load(CL_InputSource *input)
{
	for (int i=0; i<m_num; i++) m_child[i].serialize_load(input);
}
*/