/*
	$Id: inputbuffer.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include "API/Core/Input/input.h"
#include "API/Core/Input/key.h"
#include "API/Core/Input/inputbuffer.h"
#include "API/Core/Input/keyboard.h"

CL_InputBuffer::CL_InputBuffer()
{
	device = CL_Input::keyboards[0];

	CL_Input::chain_button_press.push_back(this);
	CL_Input::chain_button_release.push_back(this);
}

CL_InputBuffer::CL_InputBuffer(CL_InputDevice *device)
{
	this->device = device;

	CL_Input::chain_button_press.push_back(this);
	CL_Input::chain_button_release.push_back(this);
}

CL_InputBuffer::~CL_InputBuffer()
{
	CL_Input::chain_button_press.remove(this);
	CL_Input::chain_button_release.remove(this);
}

CL_Key CL_InputBuffer::peek_key() const
{
	if (buffer.empty())
	{
		CL_Key key;
		key.state = CL_Key::NoKey;
		return key;
	}

	return buffer.front();
}

CL_Key CL_InputBuffer::get_key()
{
	if (buffer.empty())
	{
		CL_Key key;
		key.state = CL_Key::NoKey;
		return key;
	}
	
	CL_Key key = buffer.front();
	buffer.pop();
	return key;
}

int CL_InputBuffer::keys_left()
{
	return buffer.size();
}

void CL_InputBuffer::clear()
{
	while (!buffer.empty()) buffer.pop();
}

bool CL_InputBuffer::on_button_press(
	CL_InputDevice *device,
	const CL_Key &key)
{
	if (this->device != device) return true; // wrong device.

	buffer.push(key);
	return true;
}

bool CL_InputBuffer::on_button_release(
	CL_InputDevice *device,
	const CL_Key &key)
{
	if (this->device != device) return true; // wrong device.

	buffer.push(key);
	return true;
}
