/*
	$Id: target_be.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_target_be
#define header_target_be

#include "API/Core/Display/target.h"

#include "clanwindowscreen.h"

class CL_Target_Be : public CL_Target
{
public:
	CL_Target_Be();
		
	virtual ~CL_Target_Be();

	virtual void lock();
	virtual void unlock();

	virtual void *get_data();

	virtual unsigned int get_width();
	virtual unsigned int get_height();
	virtual unsigned int get_pitch();
	
	virtual unsigned int get_depth();
	virtual unsigned int get_red_mask();
	virtual unsigned int get_green_mask();
	virtual unsigned int get_blue_mask();
	virtual unsigned int get_alpha_mask();

	virtual CL_Palette *get_palette();
	
	virtual bool is_video();
        
protected:
	ClanWindowScreen *clws;
};

#endif
