/*
	$Id: cl_gobject.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GOBJECT_H
#define CL_GOBJECT_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream>
#include <list>
#include <algorithm>

using namespace std;

class CL_GObject;
class GConnection;

typedef void (CL_GObject::*CL_GMember)();
typedef void (CL_GObject::*CL_GSlot)(int, void *);

#include "cl_gconnection.h"
#include "cl_gsldef.h"

/* The CL_GObject class implements mainly the ability for CL_GObjects to send
 * and recieve signals.
 */
class CL_GObject
{
protected:
	CL_GObject();
	virtual ~CL_GObject();

	void register_signal(CL_GMember mem);
//: Registers a signal that will be emitted by this object
//!param: mem - fhe signal

	void register_slot(CL_GSlot mem);
//: Registers a slot for this object
//!param: mem - the slot

	void deregister_signal(CL_GMember mem);
//: Deregister a signal, not really necessary to do so.
//!param: mem - the signal

	void deregister_slot(CL_GSlot mem);
//: Deregister a slot, not really necessary to do so.
//!param: mem - the slot

public:
	static void activate_signal(
		int nargs,
		CL_GObject *sender,
		CL_GMember mem,
		...);
//: Calls all the slots that are connected to the signal

	static void connect(
		CL_GObject *sender,
		CL_GMember signal,
		CL_GObject *reciever,
		CL_GSlot slot);
//: Connects an objects signal to another objects slot. When the signal is
//: 'emitted', the slot function will be called.
//!param: sender - a pointer to the object that emits the signal
//!param: signal - the signal
//!param: reciever -  a pointer to the object that has a slot
//!param: slot - the slot

	static void disconnect(
		CL_GObject *sender,
		CL_GMember signal,
		CL_GObject *reciever,
		CL_GSlot slot);
//: Disconnects an existing connection between a signal and a slot
//!param: sender - a pointer to the object that emits the signal
//!param: signal - the signal
//!param: reciever -  a pointer to the object that has a slot
//!param: slot - the slot

	static CL_GObject *get_last_sender();
//: Returns the object that last sent the signal
//!retval: The object

	static int get_num_signals() { return signals->size(); }
//: Returns the current total number of registered signals
//!retval: The number of registered signals

	static int get_num_slot() { return slots->size(); }
//: Returns the current total number of registered slots
//!retval: The number of registered slots

	static int get_num_connections() { return connections->size(); }
//: Returns the current total number of connections
//!retval: The number of slots

	static void debug_signals();

private:
	static std::list<CL_GMember> *signals;
	static std::list<CL_GSlot> *slots;
	static std::list<CL_GConnection*> *connections;
	static CL_GObject *last;
};

#endif
