/*
	$Id: cl_glabel.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GLABEL_H
#define CL_GLABEL_H

#include "cl_gwidget.h"

class CL_GLabel : public CL_GWidget
{
public:
	enum align_t {ALIGN_LEFT, ALIGN_CENTER, ALIGN_RIGHT};
	CL_GLabel(CL_GWidget* parent, int x, int y, int w, int h, CL_Font *font=0);
	virtual ~CL_GLabel();
	void set_align(align_t align) { this->align = align; needsUpdate_ = true; };
	
	DEF_SLOT_1(set_text, const char*);
  
protected:
	virtual void create();
	
	std::string			label_text;
	CL_Font*		label_font;
	align_t			align;
};
#endif



