/*
	$Id: cl_gapplication.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GAPPLICATION_H
#define CL_GAPPLICATION_H

#include "cl_gobject.h"
#include "cl_grootwindow.h"
#include "cl_gevent.h"
#include <deque>
//#include "ufont.h"
//#include "umouse.h"
//#include "uresources.h"
//#include "umixer.h"
//#include "usoundmapper.h"

///just a shortcut
#define uapp CL_GApplication::Instance


//for the DEMO
//currently disables ESC keys
//#define DEMO

///
class CL_GApplication : public CL_GObject
{
//UOBJECT

 public:
  ///
//  CL_GApplication(int, char**);
	CL_GApplication();
  ///
  ~CL_GApplication();
  
  ///
//  SLOT_DECL(quit, int);
	DEF_SLOT_1(quit, int);
  ///
//  SLOT_DECL(infoMsg, const char*);
	DEF_SLOT_1(infoMsg, const char *);

  ///50 ms timer tick
//  SIGNAL_DECL(timer, int);
	DEF_SIGNAL_1(CL_GApplication::timer, int);
  ///100ms
//  SIGNAL_DECL(timer100, int);
	DEF_SIGNAL_1(CL_GApplication::timer100, int);
  ///500ms timer tick
//  SIGNAL_DECL(timer500, int);
	DEF_SIGNAL_1(CL_GApplication::timer500, int);
  ///
/* lp  void init(int resX, int resY, int bpp,
	    bool fullscreen = false, const USurface* icon=0);
*/
	void init(int resX, int resY, int bpp, bool fullscreen = true);

  ///
  int exec();


  ///
  virtual int startupProc() { return 0;};
  ///
  virtual int shutdownProc() { return 0;};
  ///
  virtual int eventloopProc() {return 0;};
  ///
  virtual bool handleEvent(const CL_GEvent* );

  ///your app must care to load this resource
  CL_Font* getButtonFont() 
    { 
      //this returns at least an empty font
// todo      return resources_->get("button_font").font(); 
    	return btn_font;
    };
  ///
  CL_Font* getTextFont() 
    { 
//todo
	    //      return resources_->get("text_font").font(); 
    	return txt_font;
    };
 
  void setButtonFont(CL_Font *f) { btn_font = f; };
  void setTextFont(CL_Font *f) { txt_font= f; };
  
	  //
  bool startup() const { return startup_; }
  ///
  bool shutdown() const { return shutdown_; }

  ///
  CL_GRootWindow *rootWindow() { return rootWindow_; }
/* lp
  ///
  UMouse* mouse() { return mouse_; };
  ///
  UResources* resources() { return resources_; };
  ///
  UMixer* mixer() { return mixer_; };
  ///
  USoundMapper* soundMapper() { return soundMapper_; };
*/
  ///
  static CL_GApplication* Instance;

  ///
  unsigned long int ticks() const {return ticks_;}
  ///
  bool isIconified() const { return iconified_; }
  ///
  bool hasFocus() const { return focus_; }

 protected:
  
  ///
  CL_GEvent* keyrepeat();
/* lp
  ///
  enum { 
    KEY_TABLE_SIZE = SDLK_LAST , 
    KEY_DELAY = 10, // rough 500ms
    KEY_REPEAT = -1 // 0 means 100ms, -1 means 50ms
  };
*/
  ///
//lp  SDL_keysym* keyTable_;
  ///
  unsigned char* delayTable_;
  ///
  int eventloop();

  //bool get_event(CL_GEvent** event);
  CL_GEvent* poll_events();

  ///
  CL_GRootWindow *rootWindow_;
/*   lp
  ///
  UMouse *mouse_;
  ///
  UResources* resources_;
  ///
  UMixer* mixer_;
  ///
  USoundMapper* soundMapper_;
*/
  bool startup_;
  ///
  bool shutdown_;
  ///
  bool running_;

  ///
  int argc_;
  ///
  char **argv_;

  ///
  unsigned long int ticks_;
 
 private:
  ///
	bool focus_;
  ///
	bool iconified_;

	CL_GPoint curr_mouse_pos;
	CL_GPoint prev_mouse_pos;

	bool prev_left_pressed;
	bool prev_right_pressed;
	bool prev_middle_pressed;

	CL_InputBuffer *keyboard;
	
	std::deque<CL_GEvent*> *eventqueue;
	CL_Font *btn_font;
	CL_Font *txt_font;
};

#endif // !_CL_GAPPLICATION_H
  






