
//! component="System"

#ifndef header_mutex
#define header_mutex

class CL_Mutex
//: Mutex interface.
// If you don't know what a mutex is, read a book. :-)
{
public:
	static CL_Mutex *create();
	// Call this to create a mutex.

	virtual ~CL_Mutex() { ; }
	
	virtual void enter()=0;
	// Enter the critical section.

	virtual void leave()=0;
	// Leave the critical section.

	virtual void wait()=0;
	//: wait releases the mutex this thread has taken out and sends the
	// thread to sleep. Other threads can then acquire the mutex and
	// modify any data. When another thread calls notify, the thread
	// that called wait will wake up again and automatically reacquire
	// the mutex.
	//
	// <b>Warning:</b> This function must not be called on an unlocked 
	// mutex. You must call enter first.
	//
	// <b>Warning:</b> When wait returns (after another thread has called
	// notify/notifyAll, the current thread will have a mutex lock. Be
	// sure to call leave at some point.
	//
	// <b>Warning:</b> Not implemented under Win32. If you need it,
	// please implement it in Sources/Core/System/Win32/mutex_win32.*,
	// and send me the patch. :-)

	virtual void notify()=0;
	//: Notify wakes up the first thread that has gone to sleep on this
	// mutex in order to wait for a notification. For safety reasons,
	// you are advised to acquire the mutex using 'enter' before calling
	// notify. (Of course you have to release the mutex using 'leave' 
	// after notifying, otherwise the waiting thread cannot reacquire it).
	//
	// <b>Warning:</b> Not implemented under Win32. If you need it,
	// please implement it in Sources/Core/System/Win32/mutex_win32.*,
	// and send me the patch. :-)

	virtual void notify_all()=0;
	//: NotifyAll wakes up all threads waiting on the mutex.
	// <b>Warning:</b> Not implemented under Win32. If you need it,
	// please implement it in Sources/Core/System/Win32/mutex_win32.*,
	// and send me the patch. :-)
	//!also: CL_Mutex::notify
};

class CL_MutexSection
//: Lock a mutex until the end of a scope.
// This class is a way to ensure a mutex will be released at the end of 
// a scope. When an instance is constructed, it will lock the mutex, and
// when the instance is destroyed (at the exit of its scope), it will
// unlock the mutex.
{
public:
	CL_MutexSection(CL_Mutex *mutex)
	{
		this->mutex = mutex;
		mutex->enter();
	}

	virtual ~CL_MutexSection()
	{
		mutex->leave();
	}

private:
	CL_Mutex *mutex;
};

#endif
