/*
	$Id: provider_convpoly.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Header file to the ConvexPolygon surface provider.

*/

#ifndef header_provider_convpoly
#define header_provider_convpoly

#include "provider_convpoly_basics.h"
#include "../Display/surface.h"

class CL_ConvexPolygon : public CL_ConvexPolygon_Basics
{

public:
	static CL_Surface *create(CL_SurfaceProvider *src, bool delete_provider=true)
	{
		return CL_Surface::create(new CL_ConvexPolygon(src, false), delete_provider);
	}

	CL_ConvexPolygon(CL_SurfaceProvider *_src, bool _delete_provider=false);
	virtual ~CL_ConvexPolygon();

	virtual unsigned int get_num_frames() const { return src->get_num_frames(); }
	virtual CL_Palette *get_palette() const { return src->get_palette(); }
	virtual bool uses_src_colorkey() const { return trans_col != -1; }
	virtual unsigned int get_src_colorkey() const { return trans_col; }
	virtual void *get_data() const { return surface_data; }
	
	virtual unsigned int get_red_mask() const { return src->get_red_mask(); }
	virtual unsigned int get_green_mask() const { return src->get_green_mask(); }
	virtual unsigned int get_blue_mask() const { return src->get_blue_mask(); }
	virtual unsigned int get_alpha_mask() const { return src->get_alpha_mask(); }
	virtual unsigned int get_depth() const { return src->get_depth(); }
	virtual bool is_indexed() const { return src->is_indexed(); }

	virtual void perform_lock();
	virtual void perform_unlock();

protected:
	CL_SurfaceProvider *src;
	bool delete_provider;

	void *surface_data;
	int trans_col;

	// Shared locking data

	unsigned char *src_data;
	int src_pitch;
	int ysurf_pos;
	int xsurf_pos;
	int pitch;
	int width;
	int height;
	int *map_y_left;
	int *map_y_right;
	long *src_xd;
	long *src_yd;

	void create_mapping_deltas();
	void lock_8();
};

#endif
