/*
	$Id: netmessage.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Network component header file.


*/

//! component="Network"

#ifndef header_netmessage
#define header_netmessage

class CL_NetComputer;

class CL_NetMessage
//: CL_NetMessage is used to contain messages sent across the network.
{
public:
	CL_NetMessage()
	{
		from = NULL;
	}
	//: Creates a net message with no contents. (default constructor)

	CL_NetMessage(const CL_NetMessage &copy)
	{
		data = copy.data;
		from = copy.from;
	}
	//: Copy constructor.

	CL_NetMessage(void *data, int size)
	{
		this->data.append((char *) data, size);
		from = NULL;
	}
	//: Constructs a Net message using the data given. Please notice that it	
	//: doesn't duplicate the data, but only points its data pointer to the 
	//: data given.
	//!param: data - Pointer to the data to be contained by the message.
	//!param: size - Size of the data.

	CL_NetMessage(std::string data)
	{
		this->data = data;
	}

	std::string data;
	//: Packet data.

	CL_NetComputer *from;
	//: Computer the message was sent from. You don't have to fill in this
	//: if you just want to send a message - it is only used when receiving from
	//: a netchannel.
};

#endif
