/*
	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	USE AT YOUR OWN RISK TILL THIS CLASS IS EXTENSIVELY TESTED!!! I WILL
	REMOVE THIS WARNING ONCE IT BASICALLY WORKS.

	I hate documentation work and I won't document this code before any
	one besides me actually uses it. So if you want to use it simply
	write a mail on the ClanLib User list and I will do what I can :-)

	1999/12/30	vogel		renamed CL_Bezier to CL_BezierCurve
					added CL_BezierSurface

	1999/07/07	vogel		initial version


	BezierCurve TODO: 
	
	- length and stepping per curve
	
	stepping per curve means that the generated points are equidistant to 
	each other and this requires get_length() working. So at the moment all
	that is working is having 'n' equidistant points per segment.
	
	same applies to BezierSurface.
*/

//! component="Math"

#ifndef header_bezier
#define header_bezier

#include "cl_vector.h"

class CL_BezierCurve
//: Class for Bezier curves
// This class generates points on a Bezier curve from given control points
{
protected:
	CL_Vector *curve;	// the generated curve
	CL_Vector *cp;		// control points

	int steps, cs;		// number of steps, curve segments 
	bool stepping;		// steps per segment or per curve
		
	virtual void make_curve();

public:
	CL_BezierCurve(const CL_Vector *cp, int cs, int steps, bool stepping = true);
	//: Constructor
	//!param: cp - an array of control points with size (4 * cs)
	//!param: cs - number of curve segments
	//!param: steps - number of points to generate
	//!param: stepping - whether steps is the number of points per segment or per curve. 

	virtual	~CL_BezierCurve();
	//: Destructor
	
	virtual int get_steps() const { return steps; }
	//: Returns the number of steps
	//!retval: number of steps
	
	virtual int get_cs() const { return cs; }
	//: Returns the number of curve segments
	//!retval: number of curve segments

	virtual bool get_stepping() const { return stepping; }
	//: Returns whether steps is the number of points per segment or per curve.
	//!retval: stepping

	virtual float get_length(int segment = -1) const;
	//: Returns the lenght of a segment (or the curve)
	//!param: segment - number of segment (-1 indicates whole curve)
	//!retval: length of segment (or curve)
	
	virtual void set_steps(int steps);
	//: Sets the number of steps
	//!param: steps - number of steps
	
	virtual void set_stepping(bool stepping);
	//: Sets the stepping
	//!param: stepping - whether steps is the number of points per segment or per curve.

	virtual CL_Vector* get_curve() const { return curve; }
	//: Returns an array of cs * steps CL_Vectors -> the curve
	//!retval: the curve (cs * steps CL_Vectors)
	
	virtual CL_Vector* get_control_points() const { return cp; }
	//: Returns the 4 * cs control points
	//!retval: the 4 * cs control points

	CL_Vector operator [] (int n) { return curve[n]; }
	//: Returns the n-th vector of the curve (_doesn't_ return a reference)
	//!param: n - the vector to return (counting starts at 0)
	//!retval: the n-th vector of the curve (_doesn't_ return a reference)
};



class CL_BezierSurface
//: Class for Bezier surfaces
// This class generates points on a Bezier surface from given control points
{
protected:
	CL_Vector *surface;	// the generated surface
	CL_Vector *cp;		// control points

	int xsteps, ysteps;	// number of steps in x and y direction, 
	int xs, ys;		// number of surface segments om x and y direction 
	bool stepping;		// steps per segment or per surface

	virtual CL_Vector evaluate(float, float, int);
	virtual void make_surface();

public:
	CL_BezierSurface(const CL_Vector *cp, int xs, int ys, int xsteps, int ysteps, bool stepping = true);
	//: Constructor
	//!param: cp - an array of control points with size (16 * xs * ys)
	//!param: xs - number of surface segments on x direction
	//!param: ys - number of surface segments on y direction
	//!param: xsteps - number of points to generate on x direction
	//!param: ysteps - number of points to generate on x direction
	//!param: stepping - whether steps is the number of points per segment or per surface. 

	virtual	~CL_BezierSurface();
	//: Destructor
	
	virtual int get_xsteps() const { return xsteps; }
	//: Returns the number of steps
	//!retval: number of steps
	
	virtual int get_ysteps() const { return ysteps; }
	//: Returns the number of steps
	//!retval: number of steps
	
	virtual int get_xs() const { return xs; }
	//: Returns the number of surface segments
	//!retval: number of surface segments

	virtual int get_ys() const { return ys; }
	//: Returns the number of surface segments
	//!retval: number of surface segments

	virtual bool get_stepping() const { return stepping; }
	//: Returns whether steps is the number of points per segment or per curve.
	//!retval: stepping

	// virtual float get_length(int segment = -1) const;
	//: Nak Nak - don't expect it to be implemented too soon...
	//: Returns the length of a segment (or the surface)
	//!param: segment - number of segment (-1 indicates whole surface)
	//!retval: length of segment (or surface)
	
	virtual void set_xsteps(int xsteps);
	//: Sets the number of steps
	//!param: steps - number of steps
	
	virtual void set_ysteps(int ysteps);
	//: Sets the number of steps
	//!param: steps - number of steps
	
	virtual void set_stepping(bool stepping);
	//: Sets the stepping
	//!param: stepping - whether steps is the number of points per segment or per curve.

	virtual CL_Vector* get_surface() const { return surface; }
	//: Returns an array of xs * xsteps * ys * ysteps CL_Vectors -> the surface
	//!retval: the curve (xs * xsteps * ys * ystepes CL_Vectors)
	
	virtual CL_Vector* get_control_points() const { return cp; }
	//: Returns the 16 * xs * ys control points
	//!retval: the 16 * xs * ys control points

	CL_Vector operator [] (int n) { return surface[n]; }
	//: Returns the n-th vector of the curve (_doesn't_ return a reference)
	//!param: n - the vector to return (counting starts at 0)
	//!retval: the n-th vector of the curve (_doesn't_ return a reference)
};



#endif
