/*
	$Id: inputcursor.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_inputcursor
#define header_inputcursor

class CL_InputCursor
//: Input cursor interface.
// CL_InputCursor is the interface to cursors, such as a mouse cursor.
{
public:
	virtual ~CL_InputCursor() { return; }
	virtual float get_x()=0;
	//: Returns current x-coordinate.
	//!retval: Current x position.

	virtual float get_y()=0;
	//: Returns current y-coordinate.
	//!retval: Current y position.

	virtual float get_max_x()=0;
	//: Returns the range of the x-coordinate.
	//!retval: Max x coordinate value.
	
	virtual float get_max_y()=0;
	//: Returns the range of the y-coordinate.
	//!retval: Max y coordinate value.
};

#endif
