/*
	$Id: inputbutton_basic.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="InputConverters"

#ifndef header_inputbutton_basic
#define header_inputbutton_basic

#include "../Input/inputbutton.h"

class CL_InputButton_Basic : public CL_InputButton
//: CL_InputButton interface used to ease manual implementation of a input 
//: button.
{
protected:
	bool state;

public:
	CL_InputButton_Basic()
	{
		state = false;
	}
	//: Constructs an input button defaulting to not being pressed (false).
	
	CL_InputButton_Basic(bool state)
	{
		this->state = state;
	}
	//: Constructs an input button defaulting to 'state'.
	
	virtual ~CL_InputButton_Basic() {;}

	virtual bool is_pressed()
	{
		return state;
	}
	//: Returns true if the button is pressed.
	//!retval: True if pressed, false otherwise.
	
	void set_state(bool state)
	{
		this->state = state;
	}
	//: Changes the current button state. If 'state' is true, the button will be
	//: up, otherwise down.
	//!param: state - New button state. True = up, False = down.
};

#endif
