/*
	$Id: outputsource.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="I/O Data"	

#ifndef header_outputsource
#define header_outputsource

class CL_OutputSource
//: Interface to write data to different types of output sources.
// CL_OutputSource is used to write data to different types of input sources.
// In most cases, this is regular files and ClanLib zlib compressed datafiles.
// <br>
// To access some system specific output source types, such as datafiles and
// regular ones, use the static create functions in the CL_OutputSourceProvider
// class.
//!also: CL_OutputSourceProvider - Interface to open output sources with.
{
public:
	virtual ~CL_OutputSource() { return; }

	virtual void set_system_mode()=0;
	//: Changes output data endianess to the local systems mode.

	virtual void set_big_endian_mode()=0;
	//: Changes output data endianess to big endian mode.

	virtual void set_little_endian_mode()=0;
	//: Changes output data endianess to little endian mode. This is the 
	//: default setting.

	virtual void write_int32(int data)=0;
	//: Writes a signed 32 bit integer to output source.

	virtual void write_uint32(unsigned int data)=0;
	//: Writes a unsigned 32 bit integer to output source.

	virtual void write_short16(short data)=0;
	//: Writes a signed 16 bit integer (short) to output source.

	virtual void write_ushort16(unsigned short data)=0;
	//: Writes a unsigned 16 bit integer (short) to output source.

	virtual void write_char8(char data)=0;
	//: Writes a signed 8 bit integer (char) to output source.

	virtual void write_uchar8(unsigned char data)=0;
	//: Writes a unsigned 8 bit integer (char) to output source.

	virtual void write_float32(float data)=0;
	//: Writes a ieee format floating point to output source.

	virtual int write(const void *data, int size)=0;
	//: Writes larger amounts of data (no endian and 64 bit conversion):
	//: <br>
	//!param: data - Points to the array written.
	//!param: size - Number of bytes to write.
	//!retval: Num bytes actually written.
	
	virtual void open()=0;
	//: Opens the output source. By default, it is open.
	
	virtual void close()=0;
	//: Closes the output source.

	virtual CL_OutputSource *clone()=0;
	//: Make a copy of the current OutputSource, standing at the same position.
	//!retval: The copy of the output source.

	virtual int tell()=0;
	//: Returns current position in output source.
	//!retval: Current position in source.

	virtual int size()=0;
	//: Returns the size of the output source
	//!retval: Current size of output source.

	virtual void write_string(const char *string)=0;
	//: Writes a string to the output source.
};

#endif
