
#include <ClanLib/core.h>

class SinusStream : public CL_StreamSoundProvider_Session
{
public:
	SinusStream()
	{
		pos = 0;
		playing = false;
		stream_length = 60*44100; // play sound for 60 seconds.
	}
	
	virtual bool eof() const
	{
		return (pos >= stream_length); // only stream for four seconds.
	}
	
	virtual void stop()
	{
		playing = false;
	}

	virtual bool play()
	{
		playing = true;
		return true;
	}

	virtual bool set_position(int pos)
	{
		this->pos = pos;
		return true;
	}
	
	virtual int get_data(void *data_ptr, int data_requested)
	{
		int samples_req = data_requested / 2;
		if (samples_req + pos > stream_length)
		// playing beyond the end of stream data
		{
			samples_req = stream_length - pos;
			if (samples_req < 0)
			{
				stop();
				return 0;
			}
		}
		
		short *samples = (short *) data_ptr;
		
		for (int i=0; i<samples_req; i++)
		{
			samples[i] = (short) (sin(((pos+i)*440*3.14)/44100)*32000);
		}
	
		pos += samples_req;

		return data_requested; // return the amount samples given.
	}

	virtual int get_frequency() const
	{
		return 44100;
	}

	virtual SoundFormat get_format() const
	{
		return sf_16bit_signed;
	}

private:
	int pos;
	bool playing;
	
	int stream_length;
};

class SinusStreamProvider : public CL_StreamSoundProvider
{
public:
	virtual CL_StreamSoundProvider_Session *begin_session()
	{
		return new SinusStream();
	}

	virtual void end_session(CL_StreamSoundProvider_Session *session)
	{
		delete session;
	}
};

class App : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Streamed sinus test"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
	}
	
	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}
	
	virtual int main(int argc, char **argv)
	{
		CL_SetupCore::init_sound();

		CL_SoundBuffer *buffer = CL_SoundBuffer::create(
			new SinusStreamProvider,
			true);

		CL_SoundBuffer_Session session = buffer->play();
		while (session.is_playing())
		{
			CL_System::keep_alive();
			CL_System::sleep(50);
		}

		session.play();
		CL_System::sleep(2000);
		session.stop();
		
		delete buffer;

		CL_SetupCore::deinit_sound();
		return 0;
	}
} app;
