/*
   plaympeg - Sample MPEG player using the ClanLib MPEG library
   Copyright (C) 1999 Loki Entertainment Software
   Copyright (C) 1999 Daniel Vogel
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ClanLib/core.h>
#include <ClanLib/mpeg.h>


CL_MPEG *mpeg;


void update(CL_Target *dst, int x, int y, unsigned int w, unsigned int h)
{
    CL_Display::flip_display();
    mpeg->set_display(CL_Display::get_target());
}


class PlayMPEG : public CL_ClanApplication
{

public:

virtual char* get_title() { return "PlayMPEG"; }

virtual int main(int argc, char *argv[])
{
	mpeg = new CL_MPEG("mentos.mpg");
	
	if ( mpeg->get_error() ) 
	{
		cout << "error playing file" << endl;
		delete mpeg;
    		exit(-1);
	}
	    
//    	mpeg->set_audio(use_audio);
//    	mpeg->set_volume(volume);
	mpeg->set_video(true);
    	    

    	/* Set up video display if needed */
	if (mpeg->has_video()) 
	{
		unsigned int width = mpeg->get_width();
		unsigned int height = mpeg->get_height();

    		if ( false ) 
		{
    	    	        mpeg->set_double(true);
        		width *= 2;
    			height *= 2;
    		}
    
		CL_Display::set_videomode(width, height, 16);
		mpeg->set_display(CL_Display::get_target(), NULL, update);
	}
    
	/* Set any special playback parameters */
	if ( false ) 
		mpeg->set_loop(true);

	/* Play it, and wait for playback to complete */
	mpeg->play();
        
	while (mpeg->get_status() == CL_MPEG_PLAYING) {
		CL_System::keep_alive();
    		CL_System::sleep(1000/2);
	}
	delete mpeg;
	exit(0);
}
} app;	/* class PlayMPEG*/