;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: wcof -*-
;;; $Id: macros.lisp,v 1.5 2002/02/15 15:13:36 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.

(in-package :odcl)

;; define specials eaarlier on

(defvar *console-spam* t)
(defvar *console-spam-types* nil)

(defmacro handler-case-if (test form &body cases)
  `(if ,test
    (handler-case
        ,form
      ,@cases)
    ,form))

(defmacro when-bind ((var expr) &body body)
  `(let ((,var ,expr))
    (when ,var
      ,@body)))

  (defmacro if-bind ((var expr) yes no) 
    `(let ((,var ,expr))
      (if ,var
          ,yes
          ,no)))

(defmacro while (test &body body)
  "Keeps invoking the body while the test is true; test is tested
before each loop."
  (let ((end-test (gensym))
	(loop (gensym)))
    `(block nil
       (tagbody (go ,end-test) 
		,loop
		,@body
		,end-test
		(unless (null ,test) (go ,loop))
		(return)))))

(defmacro while-not (test &body body)
  "Keeps invoking the body while the test is false; test is tested
before each loop."
  (let ((end-test (gensym))
	(loop (gensym)))
    `(block nil
       (tagbody (go ,end-test)
		,loop
		,@body
		,end-test
		(unless ,test (go ,loop))
		(return)))))

;;; The following is contributed by miller@cs.rochester.edu

;;; NOTE: the full version of this package is distributed as cl-lib.

(defmacro let*-non-null (bindings &body body)
  "like let*, but if any binding is made to NIL, the let*-non-null
immediately returns NIL."
  `(block lnn (let* ,(mapcar #'process-let-entry bindings)
                    ,@body)))

(defun process-let-entry (entry)
  "if it isn't a list, it's getting a nil binding, so generate a
return. Otherwise, wrap with test."
  (declare (optimize (speed 3) (safety 0)))

  (if (atom entry)
      `(,entry (return-from lnn nil))
      `(,(car entry) (or ,@(cdr entry) (return-from lnn nil)))))

;; Explicit tagbody, with end-test at the end, to be nice to poor
;; compilers.

;; OK, how many times have you written code of the form
;;
;; (let ((retval (mumble)))
;;    (setf (slot retval) bletch)
;;    (setf (slot retval) barf)
;;    retval)
;;
;; or things of the sort? More than you care to remember most
;; likely. Enter the utterly useful PROGFOO.  Think of it as a PROG1
;; with the value being bound to FOO. inside it's extent Lexically, of
;; course.

(defmacro progfoo (special-term &body body)
  `(let ((foo ,special-term))
     ,@body
     foo))

(defmacro msetq (vars value)
 `(multiple-value-setq ,vars ,value))

(defmacro mlet (vars value &body body)
  `(multiple-value-bind ,vars ,value ,@body))

