;;; -*- Mode: Lisp -*-
;;; $Id: constants.lisp,v 1.4 2001/11/12 19:48:20 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;;
;;; constants and variables

(in-package :local-time)

(defconstant +seconds/minute+ 60
  "number of seconds in a minute")
(defconstant +minutes/hour+ 60
  "number of minutes in an hour")
(defconstant +seconds/hour+ (* +seconds/minute+ +minutes/hour+)
  "number of seconds in an hour")
(defconstant +seconds/day+ (* +seconds/hour+ 24)
  "number of seconds in a day")
(defconstant +msecs/day+ (* +seconds/day+ 1000)
  "number of milliseconds in a day")

(defparameter *system-timezone* nil
  "holds the default timezone for all time operations needing a default")

(defparameter *default-timezone* nil
  "holds the default timezone for all time operations needing a default")

(defparameter *UTC* nil)

(defparameter *local-time-universal-epoch*
  (encode-universal-time 0 0 0 1 3 2000))

(defconstant +days-in-year+ 365)

;; Months

(defvar *month-keywords*
  '(:january :february :march :april :may :june :july :august :september
    :october :november :december))

(defvar *month-names*
  '("January" "February" "March" "April" "May" "June" "July" "August"
    "September" "October" "November" "December"))

(defun month-name (month-index)
  (nth month-index *month-names*))

(defun ordinal-month (month-keyword)
  "Return the zero-based month number for the given MONTH keyword."
  (position month-keyword *month-keywords*))

;; Days

(defvar *day-keywords*
  '(:sunday :monday :tuesday :wednesday :thursday :friday :saturday))

(defvar *day-names*
  '("Sunday" "Monday" "Tuesday" "Wednesday" "Thursday" "Friday" "Saturday"))

(defun day-name (day-index)
  (nth day-index *day-names*))

(defun ordinal-day (day-keyword)
  "Return the zero-based day number for the given DAY keyword."
  (position day-keyword *day-keywords*))

;; Timezones

(defvar *timezones* (make-hash-table :test #'equal)
  "Timezones hashed by ID")
