;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: conditions.lisp,v 1.10 2001/11/27 17:30:53 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.
;;;
;;; IMHO condition classes

(in-package :imho)

(define-condition imho-error (error)
  ((text :initarg :text
        :reader imho-error-text))
  (:report (lambda (condition stream)
	     (format stream "IMHO error: ~a." (imho-error-text condition)))))
  

(define-condition imho-session-error (imho-error)
  ())

(define-condition application-condition (imho-error)
  ()
  (:report (lambda (condition stream)
	     (format stream "~A was signalled." (type-of condition)))))

(define-condition session-not-found (application-condition)
  ((missing-session-id :initarg :ssn-id :reader missing-session-id))
  (:report (lambda (condition stream)
	     (let* ((session (missing-session-id condition))
		    (string (typecase session
			      (string session)
			      (t (write-to-string session)))))
	       (format stream "Unable to restore session with id: ~A."
		       string)))))

(define-condition html-element-not-found (application-condition)
  ((html-element-id :initarg :html-element-id :reader html-element-id :initform nil))
  (:report (lambda (condition stream)
	     (let* ((comp (html-element-id condition))
		    (string (typecase comp
			      (string comp)
			      (t (write-to-string comp)))))
	       (format stream "Unable to restore html-element with id: ~A."
		       string)))))

(define-condition method-not-found (application-condition)
  ((method-name
    :initarg :method-name
    :reader method-name))
  (:report (lambda (condition stream)
	     (let* ((name (method-name condition))
		    (string (typecase name
			      (string name)
			      (t (write-to-string name)))))
	       (format stream "Unable to find webaction with name: ~A."
		       string)))))
