/* $Id: database.h 6050 2008-02-13 15:25:29Z ajc $ */

#ifndef DATABASE_H
#define DATABASE_H


void open_databases (void);
void close_databases (void);
int cdb_store (int cdb, void *key, int keylen, void *data, int datalen);
int cdb_delete (int cdb, void *key, int keylen);
struct cdbdata *cdb_fetch (int cdb, void *key, int keylen);
void cdb_free (struct cdbdata *cdb);
void cdb_rewind (int cdb);
struct cdbdata *cdb_next_item (int cdb);
void cdb_close_cursor(int cdb);
void cdb_begin_transaction(void);
void cdb_end_transaction(void);
void cdb_allocate_tsd(void);
void cdb_free_tsd(void);
void cdb_check_handles(void);
void cdb_trunc(int cdb);
void *checkpoint_thread(void *arg);
void cdb_chmod_data(void);
void cdb_checkpoint(void);
void check_handles(void *arg);

/*
 * Database records beginning with this magic number are assumed to
 * be compressed.  In the event that a database record actually begins with
 * this magic number, we *must* compress it whether we want to or not,
 * because the fetch function will try to uncompress it anyway.
 * 
 * (No need to #ifdef this stuff; it compiles ok even if zlib is not present
 * and doesn't declare anything so it won't bloat the code)
 */
#define COMPRESS_MAGIC	0xc0ffeeee

struct CtdlCompressHeader {
	int magic;
	size_t uncompressed_len;
	size_t compressed_len;
};

#endif /* DATABASE_H */

