#include "cp_types.h"
#include "cp_proto.h"

/* add verts to edges (flag=1), flip/unflip edges (flag=2/3). */

int split_flips(struct p_data *p,char *datastr,int flag)
{
  int count=0,hits,node,v,w;
  struct Edgelist *edgelist,*trace;
  char *endptr;

  if (flag==3)
    {
      if(sscanf(datastr,"%d %d",&v,&w)<2 || v<1 || w<1
	 || v>p->nodecount || w>p->nodecount || v==w) 
	return 0;
      count += flip_edge(p,v,w,flag);
      goto GETONOUT;
    }
  if ( (edgelist=Node_pair_link(p,datastr,&endptr,&hits,&Vlist,&Elist,
				&Flist,&region,pathlist,pathlength)) == NULL )
    return 0;
  if ( flag==1 && (node=p->nodecount+hits) > (p->sizelimit)
       && !alloc_pack_space(p,node,1) )
    {
      sprintf(msgbuf,
	      "Space allocation problem with adding vertices to edges.");
      emsg();
      return 0;
    }
  trace=edgelist;
  while (trace!=NULL)
    {
      if (flag==1) count += split_edge(p,trace->v,trace->w);
      else if (flag==2) count +=flip_edge(p,trace->v,trace->w,flag);
      else {edge_free(&edgelist);return 0;}
      trace=trace->next;
    }
  edge_free(&edgelist);
 GETONOUT:
  if (count)
    {
      complex_count(p,0);
      facedraworder(p,0);
      fillcurves(p);
    }
  return count;
} /* split_flips */
