#include "cp_types.h"
#include "cp_proto.h"

/* compute radii of spiral pack, parameters a,b>0. Unit circle 
at 0, tang circle, rad a, on x-axis, circle, rad b, in first quad. 
Rule: product of radii at ends of edge equals product of radii
for vertices on two sides of that edge. */

int spiral(struct p_data *p,double a,double b)
{
  int i,j,m,k0=0,k1,k2,count,flag=0,nodecount,k,alpha,l;
  complex z1,z2,cent;
  double r0,r1,r2,r3,scale,Maxx,minx,Maxy,miny,x,y,r,factor;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  nodecount=p->nodecount;
  for (i=1;i<=nodecount;i++) 
    {
      if (!pK_ptr[i].bdry_flag && pK_ptr[i].num!=6) flag++;
      pK_ptr[i].util_flag=0; 
    }
  if (flag)
    {
      strcpy(msgbuf,"Pack not hexagonal.");
      emsg();
      return 0;
    }
  alpha=p->alpha;
  pR_ptr[alpha].center.re=0.0;pR_ptr[alpha].center.im=0.0;
  pR_ptr[alpha].rad=1.0;pK_ptr[alpha].util_flag=1;
  k=pK_ptr[alpha].flower[0];
  l=pK_ptr[alpha].flower[1];
  pR_ptr[k].center.re=1.0+a;pR_ptr[k].center.im=0;
  pR_ptr[k].rad=a;
  pK_ptr[k].util_flag=1;
  z1=pR_ptr[alpha].center;z2=pR_ptr[k].center;
  e_compcenter(z1,z2,&pR_ptr[l].center,1.0,a,&b,1.0,1.0,1.0);
  pR_ptr[l].rad=b;
  pK_ptr[l].util_flag=1;
	
  count=3;
  j=0;
  while (count<nodecount)
    {
      flag=0;
      do
	{
	  j++;
	  if (j>nodecount) j=1;
	  if (!pK_ptr[j].util_flag) /* if not plotted, see if
				       there are appropriate neighbors */
	    {
	      k=0;
	      do
		{
		  k1=pK_ptr[j].flower[k];
		  k2=pK_ptr[j].flower[k+1];
		  if (pK_ptr[k1].util_flag && pK_ptr[k2].util_flag)
		    {
		      m=0;
		      while (m<=pK_ptr[k2].num 
			     && pK_ptr[k2].flower[m]!=j) m++;
		      if (m==(pK_ptr[k2].num -1)
			  && !pK_ptr[k2].bdry_flag
			  && pK_ptr[pK_ptr[k2].flower[0]].util_flag)
			{k0=pK_ptr[k2].flower[1];flag=1;}
		      else if (m<(pK_ptr[k2].num -1)
			       && pK_ptr[pK_ptr[k2].flower[m+2]].util_flag)
			{k0=pK_ptr[k2].flower[m+2];flag=1;}
		      if (flag)
			{		
			  z1=pR_ptr[k1].center;r1=pR_ptr[k1].rad;
			  z2=pR_ptr[k2].center,r2=pR_ptr[k2].rad;
			  r0=pR_ptr[k0].rad;
			  r3=r1*r2/r0;
			  e_compcenter(z1,z2,&pR_ptr[j].center,r1,r2,&r3,
				       1.0,1.0,1.0);
			  pK_ptr[j].util_flag=1;
			  pR_ptr[j].rad=r3;
			}
		      else k++;
		    } /* end of if */
		  else k++;
		} /* end of do loop */
	      while (!flag && k<=(pK_ptr[j].num-1) );
	    } /* end of if */
	} /* end of do */
      while (!flag);
      count++;
    } /* end of while */
  /* should have all centers and radii now */
  if (p->hes<0)
    {
      Maxx=1;minx=-1;Maxy=1;miny=-1;
      for (i=1;i<=nodecount;i++) 
	{
	  x=pR_ptr[i].center.re;y=pR_ptr[i].center.im;
	  r=pR_ptr[i].rad;
	  Maxx=(x+r>Maxx) ? x+r : Maxx;
	  minx=(x-r<minx) ? x-r : minx;
	  Maxy=(y+r>Maxy) ? y+r : Maxy;
	  miny=(y-r<miny) ? y-r : miny;
	}
      z1.re=(Maxx+minx)*0.5;z1.im=(Maxy+miny)*0.5;
      scale= ((Maxx-minx>Maxy-miny) ? Maxx-minx : Maxy-miny)*0.5;
      factor=(0.9)/(scale*1.4142136);
      for (i=1;i<=nodecount;i++) 
	{
	  cent.re=(pR_ptr[i].center.re-z1.re)*factor;
	  cent.im=(pR_ptr[i].center.im-z1.im)*factor;
	  r=pR_ptr[i].rad*factor;
	  e_to_h_data(cent,r,&pR_ptr[i].center,&pR_ptr[i].rad);
	}
    }
  free_overlaps(p); /* outdated */
  return 1;
} /* spiral */







