#include "cp_types.h"
#include "cp_proto.h"

/* Experimental. Uses secant method. Sets up duplicate data area. 
Assumes curvatures updated. */

int s_radcalc_norm(struct p_data *p,double valence)
{
  int v;
  struct R_data *pR_ptr,*lowR,*highR;
  double target,area,max_r,lowarea,higharea,error,factor=0.15;
  double norm_err=.00001;

  pR_ptr=p->packR_ptr;

  target=4*M_PI*valence;
		
  /* set up dup data */
  highR=(struct R_data*)malloc((p->nodecount+2)*sizeof(struct R_data));
  lowR=(struct R_data *)malloc((p->nodecount+2)*sizeof(struct R_data));
  for (v=1;v<=p->nodecount;v++) highR[v]=lowR[v]=pR_ptr[v];
	
  area=s_carrier_area(p);
  lowarea=area;
  higharea=area;
  error=area - target;
	
  if (fabs(error)> norm_err)
    {
      while (lowarea>(target))
	{
	  for (v=1;v<=p->nodecount;v++)
	    if (pR_ptr[v].aim>0) 
	      lowR[v].rad-=lowR[v].rad * factor;
	  p->packR_ptr=lowR;
	  fillcurves(p);	
	  lowarea=s_carrier_area(p);
	}

      while (higharea<(target))
	{
	  for (v=1;v<=p->nodecount;v++)
	    if (pR_ptr[v].aim>0 
		&& (max_r=max_r_adjustment(p,v))>0.0) 
	      {
		max_r= highR[v].rad+max_r;
		highR[v].rad = ((1+factor)*highR[v].rad<=max_r)
		  ? (1+factor)*highR[v].rad : max_r;
	      }
	  p->packR_ptr=highR;
	  fillcurves(p);	
	  higharea=s_carrier_area(p);		     
	}
    }	
  p->packR_ptr=pR_ptr; /* CAUTION: note, pointer has been fooled with! */

  while (fabs(error)>norm_err)
    {
      for (v=1;v<=p->nodecount;v++)
	if (pR_ptr[v].aim>=0)
	  pR_ptr[v].rad=(higharea*lowR[v].rad+lowarea*highR[v].rad)
	    /(higharea + lowarea);
		
      fillcurves(p);
      area=s_carrier_area(p);
      error= area-target;
		
      if (error>norm_err)
	{
	  for (v=1;v<=p->nodecount;v++) highR[v]=pR_ptr[v];
	  higharea=area;
	}		
      else if (error<(-norm_err))
	{
	  for (v=1;v<=p->nodecount;v++) lowR[v]=pR_ptr[v];
	  lowarea=area;
	}
    }
  free(highR);
  free(lowR);
  return 1;
} /* s_radcalc_norm */
