#include "cp_types.h"
#include "cp_proto.h"

/* routines to find circles/triangles containing particular point */

struct Vertlist *cir_search(struct p_data *p,int x,int y)
     /* list plotted circles containing canvas point (x,y). */
{
  int i;
  struct Vertlist *trace=NULL,*nodelist=NULL;

  for (i=1;i<=p->nodecount;i++)
    {
      if (pt_in_cir(p,i,x,y) && p->packK_ptr[i].plot_flag)
	{
	  if (!nodelist)
	    {
	      nodelist=(struct Vertlist *)
		calloc(1,sizeof(struct Vertlist));
	      nodelist->v=i;
	      trace=nodelist;
	    }
	  else
	    {
	      trace->next=(struct Vertlist *)
		calloc(1,sizeof(struct Vertlist));
	      trace=trace->next;
	      trace->v=i;
	    }
	}
    }
  return nodelist;
} /* cir_search */

int pt_in_cir(struct p_data *p,int n,int x,int y)
     /* pt in circle? */
{
  int front;
  double a,u,v,rad;
  complex pt,w,ectr;

  pix_to_r(x,y,&pt,p->screen->pix_box,p->screen->box);
  if (p->hes>0)
    {
      if ((a=pt.re*pt.re+pt.im*pt.im)>=1.0) return 0; 
      /* not in sphere */
      pt=proj_vec_to_sph(sqrt(1.0-a),pt.re,pt.im);
      return ( (s_dist(pt,ss_view(p->screen,
				  p->packR_ptr[n].center,1,&front))<
		p->packR_ptr[n].rad) );
    }
  if (p->hes<0)
    h_to_e_data(p->packR_ptr[n].center,
		p->packR_ptr[n].rad, &ectr,&rad);
  else if (p->hes==0)
    {
      rad=p->packR_ptr[n].rad;
      ectr=p->packR_ptr[n].center;
    }
  w=csub(pt,ectr);
  if ( (u=fabs(w.re))<rad && (v=fabs(w.im))<rad &&
       (u*u+v*v)<rad*rad ) return 1;
  return 0;
} /* pt_in_cir */

struct Vertlist *tri_search(struct p_data *p,int x,int y)
     /* list plotted (eucl) triangles under canvas pt (x,y) */
{
  int j;
  complex pt;
  struct Vertlist *trace=NULL,*nodelist=NULL;

  for (j=1;j<=p->facecount;j++)
    {
      pix_to_r(x,y,&pt,p->screen->pix_box,p->screen->box);
      if (pt_in_tri(p,j,pt.re,pt.im) && p->faces[j].plot_flag)
	{
	  if (!nodelist)
	    {
	      nodelist=(struct Vertlist *)
		calloc(1,sizeof(struct Vertlist));
	      nodelist->v=j;
	      trace=nodelist;
	    }
	  else
	    {
	      trace->next=(struct Vertlist *)
		calloc(1,sizeof(struct Vertlist));
	      trace=trace->next;
	      trace->v=j;
	    }
	}
    }
  return nodelist;
} /* tri_search */

int pt_in_tri(struct p_data *p,int n,double x,double y)
     /* complex num in triangle? */
{
  int k,rflag=0,iflag=0,front;
  complex ctr[3],pt;
  double det,dum,a;

  if (p->hes>0)
    {
      if ((a=(x*x+y*y))>=1.0) return 0; /* not in sphere */
      pt=proj_vec_to_sph(sqrt(1.0-a),x,y);
      return ( pt_in_sph_tri(pt,
			     ss_view(p->screen,p->packR_ptr
				     [p->faces[n].vert[0]].center,
				     1,&front),
			     ss_view(p->screen,p->packR_ptr
				     [p->faces[n].vert[1]].center,
				     1,&front),
			     ss_view(p->screen,p->packR_ptr
				     [p->faces[n].vert[2]].center,
				     1,&front)) );
    }
  for (k=0;k<=2;k++)
    {
      if (p->hes<0) 
	h_to_e_data(p->packR_ptr
		    [p->faces[n].vert[k]].center,
		    p->packR_ptr[p->faces[n].vert[k]].rad,
		    &ctr[k],&dum);
      else ctr[k]=p->packR_ptr
	     [p->faces[n].vert[k]].center;
      rflag += (x<=ctr[k].re);
      iflag += (y<=ctr[k].im);
    }
  if ( rflag < 3 && rflag > 0 && iflag < 3 && iflag > 0 ) 
    /* possible? */
    {
      if ((ctr[0].re*(ctr[1].im-ctr[2].im)
	   -ctr[1].re*(ctr[0].im-ctr[2].im)
	   +ctr[2].re*(ctr[0].im-ctr[1].im))>0) det=1.0;
      else det=-1.0;
      if  /* check for convex combination */
	(  (det*row_col(x,y,ctr[1].re,ctr[2].re,ctr[1].im,ctr[2].im))>0
	   && (det*row_col(x,y,ctr[2].re,ctr[0].re,ctr[2].im,ctr[0].im))>0
	   && (det*row_col(x,y,ctr[0].re,ctr[1].re,ctr[0].im,ctr[1].im))>0 )
	return 1;
		
    }
  return 0;
} /* pt_in_tri */

double row_col(double x,double y,double xa,double xb,double ya,double yb)
{ return (x*(ya-yb)-y*(xa-xb)+xa*yb-xb*ya);}
