#include "cp_types.h"
#include "cp_proto.h"

/* Compute center for vert by specified method using pairs of contig 
petals. 

flag: only use centers from computations where invdist_err < crit. Eg.
in opt=2 case, don't put poor results into average; but note this
doesn't mean different values going into average might not be off from
one another. (That's to worry about in the future.)

opt=1: by drawing order (original method): use index n0 and oriented
       nghb only. 
opt=2: average all centers as computed from pairs of contig petals,
starting with flower index n1 and going n faces around.

npf: if set, disregard plot_flag's; else use only pairs of circles 
whose plot_flag's are set.

Return 0 if center is not well-placed.  */

int fancy_comp_center(struct p_data *p,int vert,int n0,int n1,int n,
		 int flag,int opt,int npf,double crit)
{
  int count=0,i,j,k,num;
  double o1,o2,o3;
  complex z;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  num=pK_ptr[vert].num+pK_ptr[vert].bdry_flag;
  if (opt==1) {n1=n0;n=1;}
  /*  use original center already computed??
      if (pK_ptr[vert].plot_flag) z=pR_ptr[vert].center;*/
  z.re=z.im=0.0;
  for (i=n1;i<(n1+n);i++)
    {
      j=pK_ptr[vert].flower[i % num];
      k=pK_ptr[vert].flower[(i+1) % num];
      if (npf || (pK_ptr[j].plot_flag && pK_ptr[k].plot_flag))
	{
	  if (p->overlap_status)
	    {
	      o1=pK_ptr[k].overlaps[nghb(p,k,vert)];
	      o2=pK_ptr[vert].overlaps[nghb(p,vert,j)];
	      o3=pK_ptr[j].overlaps[nghb(p,j,k)];
	    }
	  else o1=o2=o3=1.0;
	  if (any_compcenter(p->hes,pR_ptr[j].center,pR_ptr[k].center,
		       &pR_ptr[vert].center,pR_ptr[j].rad,pR_ptr[k].rad,
		       &pR_ptr[vert].rad,o1,o2,o3)
	      && (!flag || (fabs(invdist_err(p,vert,j)) < crit
			    && fabs(invdist_err(p,vert,k)) < crit)))
	    {
	      z=cadd(z,pR_ptr[vert].center);
	      count++;
	    }
	}
    }
  if (!count) return 0;
  pR_ptr[vert].center.re=z.re/(count);
  pR_ptr[vert].center.im=z.im/(count);
  return (count);
} /* fancy_comp_center */


