#include "cp_types.h"
#include "cp_proto.h"

/* returns best radius at vert i to get anglesum aim, via binary search method.
First guess = r. */

extern int iterates;

double e_radcalc(struct p_data *p,int i,double r,double aim,int *chgflag)
{
  int n,flag;
  double bestcurv,lower=0.5,upper=0.5,upcurv,lowcurv,factor=0.5;

  e_anglesum_overlap(p,i,r,&bestcurv,&flag);
  if (bestcurv>(aim+okerr))
    {
      upper=r/factor;
      e_anglesum_overlap(p,i,upper,&upcurv,&flag);
      (*chgflag)++;
      if (upcurv>aim) return upper;
    }
  else if (bestcurv<(aim-okerr))
    {
      lower=r*factor;
      e_anglesum_overlap(p,i,lower,&lowcurv,&flag);
      (*chgflag)++;
      if (lowcurv<aim) return lower;
    }
  else return r;
  (*chgflag)++;
  for (n=1;n<=iterates;n++)
    {
      if (bestcurv>(aim+okerr)) 
	{
	  lower=r;
	  lowcurv=bestcurv;
	  r += (aim-bestcurv)*(upper-r)/(upcurv-bestcurv);
	}
      else if (bestcurv<(aim-okerr))
	{
	  upper=r;
	  upcurv=bestcurv;
	  r -= (bestcurv-aim)*(lower-r)/(lowcurv-bestcurv);
	}
      else return r;
      e_anglesum_overlap(p,i,r,&bestcurv,&flag);
    }
  return r;
} /* e_radcalc */
