/* adjcy_matrix.c   Read in circle packing .p file and put out matlab
   formatted adjacency matrix. */

#include "cp_types.h"
#include "cp_proto.h"
double toler=TOLER,okerr=OKERR;
char *msgbuf;
struct p_data *packdata;
FILE *fp;

int main(int argc,char *argv[])
{
  char filename[256];
  int i,j,read_key=0;

  msgbuf=(char *)calloc(1024,sizeof(char));
  strncpy (filename,argv[1],255);
  if ((packdata=(struct p_data *)
       malloc(sizeof(struct p_data)))==NULL)
    {
      sprintf(msgbuf,"RePack exited: insufficient memory.");
      emsg();
      exit(0);
    }
  packdata->overlap_status=0;
  packdata->faces=(f_data *)NULL;
  packdata->sizelimit=5000;

  if (!packdata->sizelimit || (fp=fopen(filename,"r"))==NULL
      || (packdata->packK_ptr=
	  (struct K_data *)malloc((packdata->sizelimit+1)
		 *sizeof(struct K_data)))==NULL
      || (packdata->packR_ptr=
	  (struct R_data *)malloc((packdata->sizelimit+1)
		 *sizeof(struct R_data)))==NULL
      || !(read_key=readpack(fp,packdata)) )
    {
      sprintf(msgbuf,"RePack: read of file %s failed.",filename);
      emsg();
      if (fp) fclose(fp);
      exit(2);
    }
  if (fp) fclose(fp);

  strcat(filename,"adjcy");
  if (!(fp=fopen(filename,"w"))) exit(10);
  
  fprintf(fp,"%s","adj_mat=[");
  for (i=1;i<=packdata->nodecount;i++)
    {
      for (j=1;j<=packdata->nodecount;j++)
	{
	  if (nghb(packdata,i,j)>=0) 
	    fprintf(fp," 1");
	  else fprintf(fp," 0");
	}
      fprintf(fp,";");
    }
  fprintf(fp,"]");
  fclose(fp);
  printf("Finished, exit.");
  exit(0);
}
	
int emsg()
{printf(msgbuf);}

int msg()
{printf(msgbuf);fsync((int)stdout);}

