/* CP_proto.h   These are procedure prototypes for things specific
   to CirclePack and the cp_*.c files (whereas cp_proto.h is for
   the more generic library routines */

#include "cp_types.h"

/* cp_action.c */
int script_sw_notify_proc();
char *find_script_data(char *datastr,int flag);
int find_next_script_cmd(int direction,int ex_flag);
int exe_named_cmd(char *datastr,int *targ_p);
int cmd_proc();
int cmd_line_proc();
int handle_cmd_proc();
int pack_proc();
int handle_path_io_proc();
int handle_write_proc();
int handle_pack_proc();
int screen_up_proc();
int setup_proc();
int handle_screen_up_proc();
int cmd_up_proc();
int cmd_up(int sflag);
int script_up_proc();
int Radjust_proc();
int handle_radjust_proc();
int Oadjust_proc();
int handle_oadjust_proc();
int Cadjust_proc();
int handle_cadjust_proc();
int win_save_proc();
int save_workspace();
int quit_proc();
int quit();
int help_proc();
int history_proc();
int Kadjust_proc();
int handle_kadjust_proc();
int handle_set_abc_proc();
int handle_add_proc();
int handle_remove_proc();
int inquiry_proc();
int handle_inquiry_proc();
int handle_sel_inq_proc();
int handle_spec_inq_proc();
int misc_proc();
int handle_misc_proc();
int handle_repack_proc();
int handle_fix_proc();
int handle_mob_proc();
int special_proc();
int handle_special_proc();
int color_proc();
int handle_cir_color_proc();
int handle_face_color_proc();
int factor_inc_proc();
int eucl_factor_proc();
int fill_pattern_proc();
int active_p_proc();
int chg_active_pack(int pnum);
int pack_num(struct p_data *p);
int screen_num(struct s_data *q);
int param_proc();
int handle_param_proc();
int close_setup_proc();
int canvas_life(int pnum,int act);
int screen_toggles_proc();
int screen_coord_proc();
int reset_proc();
int close_popup_proc();
int screen_factor_proc();
int screen_size_proc();
int screen_c_proc();
int handle_c_menu_proc();
int s_display_proc();
int base_resize_proc();
int canvas_s_proc();
int cl_pr_proc();
int canvas_num1();
int canvas_repaint_proc();
int scr_popup_proc();
int cir_com_proc();
int clr_proc();
int circles_ofs_proc();
int complex_ofs_proc();
int label_proc();
int output_proc();
int canvas_evt();
int mark(struct p_data *p,int i);
int manip_proc();
int show_manip_frame_proc();
int ms_repack_proc();
int show_path_proc();
int quicksave_proc();
int manip_frame_done_proc();
int set_packing_path();
long find_token(FILE *fp,long pos,char **string,char *token);
int find_name(FILE *fp,char *name,long *pos);

/* cp_call.c */

struct Vertlist *node_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits);
struct Vertlist *face_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits);
struct Edgelist *node_pair_link(struct p_data *p,char *dpoint,
				char **endptr,int *hits);
int cmd_search(char *datastr,int *shift);
int match_call(struct p_data *p,char *datastr);
int blend_call(struct p_data *p,char *datastr);
int path_construct_call(struct p_data *p,char *datastr);
int vert_order_call(struct p_data *p);
int get_put_data_call(struct p_data *p,char *datastr,int rev_flag);
int cir_invert_call(struct p_data *p,char *datastr);
int molify_call(struct p_data *p,char *datastr);
int fix_call(struct p_data *p,char *datastr);
int cookie_call(struct p_data *p,char *datastr);
int diag_call(struct p_data *p,char *datastr);
int reverse_orient_call(struct p_data *p);
int puncture_call(struct p_data *p,char *datastr);
int swap_nodes_call(struct p_data *p,char *datastr);
int add_circles_call(struct p_data *p,char *datastr);
int geom_to_e_call(struct p_data *p,char *datastr);
int geom_to_h_call(struct p_data *p,char *datastr);
int geom_to_s_call(struct p_data *p,char *datastr);
int riffle_call(struct p_data *p,int passes,int lpr,int flag);
int gen_cut_call(struct p_data *p,char *datastr);
int gen_mark_call(struct p_data *p,char *datastr);
int spiral_call(int pnum,char *datastr);
int NSpole_call(struct p_data *p,char *datastr);
int rect_ratio_call(struct p_data *p,char *datastr);
int marking(struct p_data *p,char *datastr);
int norm_scale_call(struct p_data *p,char *datastr);
int set_aim_call(struct p_data *p,char *datastr);
int randize(struct p_data *p,char *datastr);
int max_pack(struct p_data *p,char *datastr);
int reset_screen(struct s_data *q);
int enfoldcall(struct p_data *p,char *datastr);
int adjoincall(char *datastr);
int color_circles(struct p_data *p,int f,char *datastr);
int color_faces(struct p_data *p,int f,char *datastr);
int map_list_call(struct p_data *p,char *datastr);
int adjacency_call(struct p_data *p,char *datastr);
int write_light_call(struct p_data *p,char *datastr,int flag);
int write_parse(struct p_data *p,char *datastr);
int timedelay(double tm);
int set_overlapscall(struct p_data *p,char *datastr);
int set_screen_call(struct p_data *p,char *datastr);
int set_postfile_call(int flag,char *datastr);
int find_help_packrc(char *argv0);
int read_packrc(char *filename);
int read_workspace(int script_flag);
int read_rgb_file();
int hex_parallel_call(struct p_data *p,int v,int w,int n,complex *cmod,
		      int show);
struct Vertlist *try_hex_pg(struct p_data *p,int v,int w,int n,
			    int *v1,int *v2,int *v3,int *v4);
int j_ftn_call(struct p_data *p,char *datastr);
int mend_call(struct p_data *p,char *datastr);
int h_dist_call(char *datastr);
int focus_call(struct p_data *p,char *datastr);

/* cp_cmd.c */

int sort_cmd(char *cmd_stream,int *targ_p);
int handle_cmd(char *command,int *targ_p);
int parse_cmd(struct p_data *p,int *hflag,int *targ_p);

/* cp_format.c */

int frame_builder();
int create_panel_sw();
int create_script_frame();
int create_config_win();
int create_screen_popups();
int create_subwindows();
int create_canvas_frames();
int create_manip_frame();
int create_cursors();

/* cp_io.c */

int readcall(struct p_data *p,char *filename);
int call_read_pack(FILE *fp,struct p_data *p,char *packname);
int writecall(struct p_data *p,char *filename,int act);
int write_consolidate(struct p_data *p,char *filename);
int open_and_write(struct p_data *p,char *filename,int act);
int read_path_file(char *filename);
int write_path_file(char *filename);
int copy_packcall(char *datastr);
int seed_start_call(struct p_data *p,char *datastr);
int empty_pack(struct p_data *p);
int confirm_action(char *message);
int print_inq_data(struct p_data *p,int f,char *datastr);
int close_script_proc();
int reset_script_proc();
int reset_script();
int find_script_proc();
int next_script_proc();
int read_infile(struct p_data *p,char *datastr);
int cmds_infile(char *datastr);
int path_infile(char *datastr);
int fexec_call(char *datastr);
int c_initmem();
int c_rdmem(int *vnum,char *vstr);
int c_wrmem(int *vnum,char *vstr);
int cmd_import(char *datastr);
int cmd_export(struct p_data *p,char *datastr);
char *get_selection(int kill);
int stat_file(char *filename);
int print_proc();
int sel_print_proc();
int post_canvas(struct p_data *p);
int print_psfile(FILE **FP);

/* cp_remote.c */

int init_remote(char *datastr);
int open_service();
int reset_lock(struct p_data *p,int hit,int flag);
int check_lock(int pnum,int proc);

/* cp_screen.c */

int display_call(struct p_data *p,char *datastr);
int disp_screen(struct p_data *p,int cflag,int fflag,int show);
int coord_axes(struct p_data *p);
int caption(struct s_data *q,char *datastr);
int clear_canvas(struct s_data *q);
int draw_in_order(struct p_data *p,int cflag,int fflag,int pl,int show);
int layout_report(struct p_data *p,int v,int flag);
struct Vertlist *parse_facepath(struct p_data *p,struct Pathlist *path,
				int *livenode);
int refresh_canvas(struct s_data *q);
int set_cursor(struct s_data *q,int m);
int msg();
int emsg();
int smsg();
int hmsg(char *msg);
int pmsg(int i,char *msg);
int msg_remote(int i);
int canvmsg(int i);
int set_pack_labels();
int repack_activity_msg(char *datastr);
int sphere_view(struct s_data *q,char *datastr);

/* cp_special.c */

int create_special_menu();
int special1(char *datastr);
int special2(char *datastr);
int special3(char *datastr);
int special4(char *datastr);
int special5(char *datastr);
int special6(char *datastr);
int special7(char *datastr);
int special8(char *datastr);
int special9(char *datastr);

/* cp_xview.c */

int set_print_file(char *datastr);
int set_ps_file(char *datastr);
int set_pack_dir_name(char *datastr);
int set_print_cmd(char *datastr);
char *get_print_file();
char *get_ps_file();
char *get_pack_dir_name();
char *get_print_cmd();
int set_u_cir_flag(int pnum,int truefalse);
int set_coord_flag(int pnum,int truefalse);
int set_script_name(char *filename);
